
;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold without
;;;; written permission from the Regents of the University of California.
;;;; The code contained in this file was written by Cliff Brunk.


;;;_______________________________________
;;;  window-hardcopy

(defmethod window-hardcopy ((window graph-window) &optional (show-dialog? t))
  (declare (ignore show-dialog?))
  (hardcopy-graph-in-window window))

;;;_______________________________________
;;;  hardcopy-graph-in-window

(defun hardcopy-graph-in-window (window)
  (let (THPrint TPPtPort)
    (unwind-protect
      (let* ((view (graph-view window))
             (picture (export-graph-picture view))
             (g-left (graph-left view))
             (g-top (graph-top view))
             (g-right (graph-right view))
             (g-bottom (graph-bottom view))
             (g-size-h (- g-right g-left))
             (g-size-v (- g-bottom g-top))
             (tile-overlap 15))
        (setf THPrint (#_NewHandle (record-length :tprint)))
        (unwind-protect
          (with-cursor *arrow-cursor*
            (#_PrOpen)
            (#_PrValidate THPrint)
            (when (#_PrJobDialog THPrint)
              (view-draw-contents window)
              (unwind-protect
                (progn
                  (setf TPPtPort (#_PrOpenDoc THPrint (%null-ptr) (%null-ptr)))
                  (let* ((page-size-h (rref THPrint :TPrint.prInfo.rpage.right))
                         (page-size-v (rref THPrint :TPrint.prInfo.rpage.bottom))
                         (pages-h (ceiling g-size-h  page-size-h))
                         (pages-v (ceiling g-size-v page-size-v)))
                    (if (> pages-h 1)
                      (setf page-size-h (- page-size-h tile-overlap)
                            pages-h (ceiling g-size-h page-size-h)))
                    (if (> pages-v 1)
                      (setf page-size-v (- page-size-v tile-overlap)
                            pages-v (ceiling g-size-v page-size-v)))
                    (dotimes (page-v pages-v)
                      (dotimes (page-h pages-h)
                        (unwind-protect
                          (with-port TPPtPort
                            (#_PrOpenPage TPPtPort (%null-ptr))
                            (rset TPPtPort :grafport.txFont (rref (wptr window) :WindowRecord.txFont))
                            (rset TPPtPort :grafport.txFace (rref (wptr window) :WindowRecord.txFace))
                            (rset TPPtPort :grafport.txSize (rref (wptr window) :WindowRecord.txSize))
                            (let* ((frame-size (subtract-points (rref picture picture.picframe.bottomright)
                                                                (rref picture picture.picframe.topleft)))
                                   (top (- (* page-v page-size-v)))
                                   (left (- (* page-h page-size-h)))
                                   (bottom (+ top (point-v frame-size)))
                                   (right (+ left (point-h frame-size))))
                              (rlet ((frame :rect :top top :left left :bottom bottom :right right))
                                (#_DrawPicture picture frame))))
                          (#_PrClosePage TPPtPort))
                        ))
                    ))
                (#_PrCloseDoc TPPtPort))
              (when (equalp (rref THPrint :TPrint.prJob.bJDocLoop) 1)
                (%stack-block ((TPrStatus (record-length :TPrStatus)))
                  (#_PrPicFile THPrint (%null-ptr) (%null-ptr) (%null-ptr) TPrStatus) ))
              ))
          (#_PrClose))
        )
      (#_DisposeHandle THPrint))
    ))