
;;;  Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;  This program may be freely copied, used, or modified provided that this
;;;  copyright notice is included in each copy of this code.  This program
;;;  may not be sold or incorporated into another product to be sold without
;;;  written permission from the Regents of the University of California.
;;;  The code in this file was written by Cliff Brunk.

(in-package :user)

;;;_________________________________________________________
;;;  close-display-windows ()

(defun close-display-windows ()
  (map-windows #'window-close :class 'inspector::backtrace-window :include-invisibles t)
  (map-windows #'window-close :class 'inspector::inspector-window :include-invisibles t)
  (map-windows #'window-close :class 'graph-window :include-invisibles t)
  (map-windows #'window-close :class 'learning-window :include-invisibles t)
  (map-windows #'window-close :class 'analyze-window :include-invisibles t)
  (map-windows #'window-close :class 'gain-window :include-invisibles t)
  (map-windows #'window-close :class 'rule-edit-window :include-invisibles t)
  (map-windows #'window-close :class 'theory-edit-window :include-invisibles t)
  (update-relations)
  (update-cliches)
  (if (window-open? *WORK-WINDOW*) (window-close *WORK-WINDOW*)))

;;;_________________________________________________________
;;;  init-display-learning-windows

(defun init-display-learning-windows ()
  (if (member :ebl *focl-display-level*) (setup-EBL-WINDOW))
  (if (member :work *focl-display-level*) (setup-WORK-WINDOW))
  (if (member :learned-description *focl-display-level*) (setup-LEARNED-DESCRIPTION-WINDOW))
  (if (member :best-gain *focl-display-level*) (setup-BEST-GAIN-WINDOW))
  (if (member :current-gain *focl-display-level*) (setup-CURRENT-GAIN-WINDOW))
  (if (member :pause-before-learning *focl-display-level*) (pause)))

;;;_________________________________________________________
;;; change-learning-parameters

(defun change-learning-parameters (&optional (modify-button-name " Set "))
  (multiple-value-bind (current-pred current-parameters) (collect-learning-parameters)
    (apply #'set-learning-parameters (first *focl-problem*) (rest *focl-problem*))
    (if (equalp (catch-cancel (modal-dialog (learning-settings-dialog modify-button-name) t)) :cancel)
      (apply #'set-learning-parameters current-pred current-parameters)
      (when (user-monitor-p *user-monitor*)
        (incf (user-monitor-change-learning-parameters *user-monitor*)))))
  (values))

;;;_________________________________________________________
;;; allow-user-to-change-parameters-or-cancel

(defun allow-user-to-change-parameters-or-cancel ()
  (modal-dialog (learning-settings-dialog "Learn") t))

#|
;;;_________________________________________________________
;;; learn

(defun learn ()
  (when (and (fboundp 'find-concept-description)
             (get-pred (first *focl-problem*)))
    (when (user-monitor-p *user-monitor*)
      (incf (user-monitor-learn *user-monitor*)))
    (apply #'set-learning-parameters (first *focl-problem*) (rest *focl-problem*))
    (window-hide *top-listener*)
    (menu-install *es-learning-menu*)
    (unwind-protect
      (let ((*backtrace-on-break* nil)
            (*error-output* ccl::*terminal-io*))
        (find-concept-description)
        (print-learned-description))
      (menu-deinstall *es-learning-menu*)
      (window-select *top-listener*)))
  (values))
|#

;;;_________________________________________________________
;;;  display-status

(defun display-status (status)
  (when (window-open? *LEARNED-DESCRIPTION-WINDOW*)
    (set-dialog-item-text
     (view-named :status *LEARNED-DESCRIPTION-WINDOW*)
     (format nil "Status:   ~a"
             (case status
               (:paused "Paused")
               (:finished-learning "Finished Learning")
               (:extensional "Extensional Induction")
               (:builtin "Builtin Induction")
               (:intensional "Intensional Induction")
               (:cliche "Clich Instantiation")
               (:determinate "Determinate Addition")
               (:ebl "Explanation Based Learning")
               (:simplify-o "Simplifying Operationalization")
               (:simplify-c "Simplifying Clause")
               (t (format nil "~@(~A~)" status)))))
    (event-dispatch)
    ))


;;;=====================================================================
;;; Explanation Based Learning
;;;=====================================================================


;;;_________________________________________________________
;;;  setup-EBL-WINDOW

(defun setup-EBL-WINDOW (&optional (goal-concept *goal-concept*))
  (let ((font '("Chicago" 12 :SRCOR :PLAIN)))
    (when (window-open? *EBL-WINDOW*)
      (window-close *EBL-WINDOW*))
    (when (and goal-concept *use-goal-concept*)
      (without-interrupts
       (setf *EBL-WINDOW* (make-instance 'learning-window
                            :window-show nil
                            :window-title "Explanation Based Learning"
                            :view-position #@(2 42)))
       (add-subviews
        *EBL-WINDOW*
        (make-dialog-item 'static-text-dialog-item #@(7 2) #@(100 16) "" nil :view-font font :view-nick-name :source)
        (make-dialog-item 'static-text-dialog-item #@(115 2) #@(80 16) "" nil :view-font font :view-nick-name :gain)
        (make-dialog-item 'static-text-dialog-item #@(220 2) #@(60 16) "" nil :view-font font :view-nick-name :pos)
        (make-dialog-item 'static-text-dialog-item #@(280 2) #@(60 16) "" nil :view-font font :view-nick-name :neg))

       (let ((view (graph-view *EBL-WINDOW*))
             (root (graph-root *ebl-graph*)))
         (setf (expand view) :always
               (orientation view) :horizontal
               (root view) root
               (graph view) *ebl-graph*
               (graph-views *ebl-graph*) (push view (graph-views *ebl-graph*))
               (node-selection-constraint view) :no-selection)
         (display-tree-cells view root)
         (size-all-cells view)
         (position-cells view)
         (resize-window *EBL-WINDOW*)
         (position-graph view :centered t)
         (force-graph-redraw view)
         (window-select *EBL-WINDOW*)
         *EBL-WINDOW*)))))

;;;_________________________________________________________
;;;  re-init-ebl-window

(defun re-init-ebl-window (window base pos-tuples neg-tuples)
  (when (window-open? window)
    (without-interrupts
     (let ((view (graph-view window)))
       (clear-external-text view)
       (display-caption window (format nil "~@(~A~)" *refinement*) "" "" "")
       (setf (cell-external-text (node-cell (graph-view window) base))
             (format nil "~A+ ~A-  Uncovered" (length pos-tuples) (length neg-tuples)))
       (invalidate-view view t)))))


;;;=====================================================================
;;; WORK
;;;=====================================================================

;;;_________________________________________________________
;;;  setup-WORK-WINDOW

(defun setup-WORK-WINDOW ()
  (when (window-open? *WORK-WINDOW*)
    (window-close *WORK-WINDOW*))
  (let
    ((x0 10) (x1 20) (w1 150) (w2 220) (w3 290) (y 5)
     (display-font '("Chicago" 12 :SRCOR :PLAIN))
     (display-underline-font '("Chicago" 12 :SRCOR :UNDERLINE))
     (size (make-point 60 14)) (zero (format nil "~6@A" 0)) (stdi 'static-text-dialog-item))
    (setf
     *WORK-WINDOW*
     (make-instance
      'dialog :window-show nil :window-type :document :window-title "Work"
      :view-position '(:left 2) :view-size #@(345 150) :view-font display-font :close-box-p t
      :view-subviews
      (list 
       (make-dialog-item stdi (make-point x0 y) nil "Literals Tested:" nil)
       (make-dialog-item stdi (make-point 140 y) nil "Literal" nil :view-font display-underline-font)
       (make-dialog-item stdi (make-point 210 y) nil "Clause" nil :view-font display-underline-font)
       (make-dialog-item stdi (make-point 280 y) nil "Theory" nil :view-font display-underline-font)
       
       (make-dialog-item stdi (make-point x1 (incf y 20)) nil "Extensional" nil)
       (make-dialog-item stdi (make-point w1 y) size zero nil :view-nick-name :extensional-literal)
       (make-dialog-item stdi (make-point w2 y) size zero nil :view-nick-name :extensional-clause)
       (make-dialog-item stdi (make-point w3 y) size zero nil :view-nick-name :extensional-theory)
       
       (make-dialog-item stdi (make-point x1 (incf y 16)) nil "Builtin" nil)
       (make-dialog-item stdi (make-point w1 y) size zero nil :view-nick-name :builtin-literal)
       (make-dialog-item stdi (make-point w2 y) size zero nil :view-nick-name :builtin-clause)
       (make-dialog-item stdi (make-point w3 y) size zero nil :view-nick-name :builtin-theory)
       
       (make-dialog-item stdi (make-point x1 (incf y 16)) nil "Intensional" nil)
       (make-dialog-item stdi (make-point w1 y) size zero nil :view-nick-name :intensional-literal)
       (make-dialog-item stdi (make-point w2 y) size zero nil :view-nick-name :intensional-clause)
       (make-dialog-item stdi (make-point w3 y) size zero nil :view-nick-name :intensional-theory)
       
       (make-dialog-item stdi (make-point x1 (incf y 16)) nil "Determinate" nil)
       (make-dialog-item stdi (make-point w1 y) size zero nil :view-nick-name :determinate-literal)
       (make-dialog-item stdi (make-point w2 y) size zero nil :view-nick-name :determinate-clause)
       (make-dialog-item stdi (make-point w3 y) size zero nil :view-nick-name :determinate-theory)
       
       (make-dialog-item stdi (make-point x1 (incf y 16)) nil "Clich" nil)
       (make-dialog-item stdi (make-point w1 y) size zero nil :view-nick-name :cliche-literal)
       (make-dialog-item stdi (make-point w2 y) size zero nil :view-nick-name :cliche-clause)
       (make-dialog-item stdi (make-point w3 y) size zero nil :view-nick-name :cliche-theory)
       
       (make-dialog-item stdi (make-point x1 (incf y 16)) nil "EBL" nil)
       (make-dialog-item stdi (make-point w1 y) size zero nil :view-nick-name :ebl-literal)
       (make-dialog-item stdi (make-point w2 y) size zero nil :view-nick-name :ebl-clause)
       (make-dialog-item stdi (make-point w3 y) size zero nil :view-nick-name :ebl-theory)
       
       (make-dialog-item stdi (make-point x1 (incf y 20)) nil "TOTAL" nil)
       (make-dialog-item stdi (make-point w1 y) size zero nil :view-nick-name :total-literal)
       (make-dialog-item stdi (make-point w2 y) size zero nil :view-nick-name :total-clause)
       (make-dialog-item stdi (make-point w3 y) size zero nil :view-nick-name :total-theory)
       ))))
  (window-select *WORK-WINDOW*))


;;;_________________________________________________________
;;;  display-work

(defun display-work (literal-work clause-work theory-work)
  (when (window-open? *WORK-WINDOW*)
    (let ((window *WORK-WINDOW*))
      (set-dialog-item-text (view-named :extensional-literal window) (format nil "~6@A" (work-extensional literal-work)))
      (set-dialog-item-text (view-named :extensional-clause window) (format nil "~6@A" (work-extensional clause-work)))
      (set-dialog-item-text (view-named :extensional-theory window) (format nil "~6@A" (work-extensional theory-work)))
      
      (set-dialog-item-text (view-named :builtin-literal window) (format nil "~6@A" (work-builtin literal-work)))
      (set-dialog-item-text (view-named :builtin-clause window) (format nil "~6@A" (work-builtin clause-work)))
      (set-dialog-item-text (view-named :builtin-theory window) (format nil "~6@A" (work-builtin theory-work)))
      
      (set-dialog-item-text (view-named :intensional-literal window) (format nil "~6@A" (work-intensional literal-work)))
      (set-dialog-item-text (view-named :intensional-clause window) (format nil "~6@A" (work-intensional clause-work)))
      (set-dialog-item-text (view-named :intensional-theory window) (format nil "~6@A" (work-intensional theory-work)))
      
      (set-dialog-item-text (view-named :determinate-literal window) (format nil "~6@A" (work-determinate literal-work)))
      (set-dialog-item-text (view-named :determinate-clause window) (format nil "~6@A" (work-determinate clause-work)))
      (set-dialog-item-text (view-named :determinate-theory window) (format nil "~6@A" (work-determinate theory-work)))
      
      (set-dialog-item-text (view-named :cliche-literal window) (format nil "~6@A" (work-cliche literal-work)))
      (set-dialog-item-text (view-named :cliche-clause window) (format nil "~6@A" (work-cliche clause-work)))
      (set-dialog-item-text (view-named :cliche-theory window) (format nil "~6@A" (work-cliche theory-work)))
      
      (set-dialog-item-text (view-named :ebl-literal window) (format nil "~6@A" (work-ebl literal-work)))
      (set-dialog-item-text (view-named :ebl-clause window) (format nil "~6@A" (work-ebl clause-work)))
      (set-dialog-item-text (view-named :ebl-theory window) (format nil "~6@A" (work-ebl theory-work)))
      
      (set-dialog-item-text (view-named :total-literal window)
                            (format nil "~6@A" (+ (work-extensional literal-work)
                                                  (work-builtin literal-work)
                                                  (work-intensional literal-work)
                                                  (work-determinate literal-work)
                                                  (work-cliche literal-work)
                                                  (work-ebl literal-work))))
      (set-dialog-item-text (view-named :total-clause window)
                            (format nil "~6@A" (+ (work-extensional clause-work)
                                                  (work-builtin clause-work)
                                                  (work-intensional clause-work)
                                                  (work-determinate clause-work)
                                                  (work-cliche clause-work)
                                                  (work-ebl clause-work))))
      (set-dialog-item-text (view-named :total-theory window)
                            (format nil "~6@A" (+ (work-extensional theory-work)
                                                  (work-builtin theory-work)
                                                  (work-intensional theory-work)
                                                  (work-determinate theory-work)
                                                  (work-cliche theory-work)
                                                  (work-ebl theory-work))))
      (event-dispatch)
      )))


;;;=====================================================================
;;; PAUSE and RESUME
;;;=====================================================================

(defun pause () (push-status :paused) (break "Paused..."))

(defun resume () (pop-status) (continue))

(defun pause-resume () (if (> ccl::*break-level* 0) (resume) (pause)))
