
;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold withou
;;;; written permission from the Regents of the University of California.
;;;; This program was written by Michael Pazzani, Cliff Brunk, Glenn Silverstein
;;;; and Kamal Ali.  

(in-package :user)

(defun prune (variabilization variabilizations prune-condition)
   (dolist (other-varzn-struct variabilizations nil)
      (when (more-general variabilization 
                          (variabilization-struct-variabilization other-varzn-struct))
            (progn
              (when (and *trace-learning?* (member :pr *focl-trace-level*))
                (format t "~&~a-pruned: ~a by ~a" 
                      prune-condition
                      (variabilization-struct-variabilization other-varzn-struct)
                      variabilization))
              (setf (variabilization-struct-look-at-negative? other-varzn-struct) t)
              (setf (variabilization-struct-look-at-positive? other-varzn-struct) nil)))))

(defun prune-negations (variabilization variabilizations prune-condition)
   (dolist (other-varzn-struct variabilizations nil)
      (when (more-general (variabilization-struct-variabilization other-varzn-struct)
                          variabilization)
            (progn
              (when (and *trace-learning?* (member :pr *focl-trace-level*))
                (format t "~&~a-pruned: NOT~a by NOT~a" 
                        prune-condition
                        (variabilization-struct-variabilization other-varzn-struct)
                        variabilization))
              (setf (variabilization-struct-look-at-negative? other-varzn-struct) nil)))))


;;; varzn is an abbreviation for variabilization
;;; assumes length of curr-varzn == length of other-varzn
(defun more-general (curr-varzn other-varzn)
  (let ((bindings nil)
        (old-binding nil)
        (more-general-flag t)) ; set to nil as soon as there
                               ; is a detection of failure
    (do ((current-var (car curr-varzn) (car curr-varzn))
         (curr-varzn (cdr curr-varzn) (cdr curr-varzn))
         (other-var (car other-varzn) (car other-varzn))
         (other-varzn (cdr other-varzn) (cdr other-varzn)))
        
        ; terminating condition
        ((or (null more-general-flag) (null current-var)) more-general-flag)
        (cond ((new-var? current-var)
               (setq old-binding (cdr (assoc current-var bindings)))
               (if (null old-binding)
                   (setq bindings (acons current-var other-var bindings)) ; put new binding on alist
                   (unless (equal old-binding other-var)
                     (setq more-general-flag nil))))

              ; curr-var is an old var
              ; here follow the conditions for setting the flag to nil:
              ((null other-var)
               (format t "~& c-v: ~a o-v: ~a cv-l: ~a ov-l: ~a"
                       current-var other-var curr-varzn other-varzn))
              (t (when (or (new-var? other-var)
                           (not (equal current-var other-var)))
                   (progn
                        (setq more-general-flag nil))))
              
              )))) ; defun more-general
                  