
;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold withou
;;;; written permission from the Regents of the University of California.
;;;; This program was written by Michael Pazzani, Cliff Brunk, Glenn Silverstein
;;;; and Kamal Ali.  

(in-package :user)
(defvar *covered-all-pos-tuples* nil)
(defvar *refinement* nil)
(defvar *batch* nil) ; don't ask the user questions 
(defparameter *occur-check* nil)  ; Performs an occur check if T
(defparameter *use-gensyms* t)  ; Uses gensym to create unique variables if T otherwise uses copy-symbol

(defvar *all-types* nil)      ; all user defined types
(defvar *special-types* nil)  ; list of special types defined by system user may not modify definition of
(defvar *type-properties* '(:object :no-type-in :picture))

(defvar *selection-function* nil)  ;;:maximum or :probabilitistic

(defparameter *deleted-clauses-and-literals* (make-hash-table :test #'equal))
(defparameter *add-determinate-gain-threshold* 0)
;;; add determinate literals when gain of best literal so far is less than
;;; (* *add-determinate-gain-threshold* max-possible-gain)
;;; to emulate FOIL's behavior
;;; (setq *add-determinate-gain-threshold* .80)

;; -- count ----------------------------------------
(defvar *extensional-preds* nil)  ;; alist (name . r-struct) of extensionally defined relations
(defvar *builtin-preds* nil)      ;; alist (name . r-struct) of relations defined by LISP predicates
(defvar *intensional-preds* nil)   ;; alist (name . r-struct) of intensionally defined relations

(defvar *r-structs* nil)           ;; list of all relations maintained in alphabetical order
(defvar *special-r-structs* nil)   ;; list of special relations defined by system user may not modify definitions of
;;(defparameter *dont-change-these-prolog-functions* '(string-lessp/2 eql/2 >=/2 <=/2 </2 math-=/2 >/2 ==/2 =/2))


(defvar *print-deleted-literals* T)    ;determines whether deleted literals should be skipped or printed
(defvar *predicate-being-learned* nil) ;set by focl, used by prolog to avoid extensional definition
                                       ;of predicate being learned
(defvar *init-slot-table-size* 10)
(defvar *slot-table-rehash-threshold* .9)
(defvar *slot-table-rehash-size* 1.5)
(defvar *domain* nil)

(defvar *example-arity* 0)
(defvar *count-examples-as-original-matches* nil)
(defvar *count-all-matches* nil)
(defvar *max-number-of-observed-extensions* 0)


;; -- focl ----------------------------------------
(defvar *operationalize-intensional* t)
(defvar *simplify-clauses* t)
(defvar *extensional-induction* t)
(defvar *builtin-induction* t)
(defvar *intensional-induction* nil)
(defvar *template-induction* nil)
(defvar *proof-vars-available* t)
(defvar *variablizations-checked* 0)
(defvar *stopping-criteria-enabled* nil)
(defvar *print-warnings* nil)
(defvar *partial-dt-0-gain* nil) 
(defvar *simplify-operationalizations* nil)
(defvar *gain-function* nil)     ;; only by opertaionalize for now.
(defvar *prefer-deletions* nil)  ;; controls how ties are handled in operationalize
(defvar *prefer-children* nil)   ;; cab changed from t to nil CAB (11/16/92)  
(defvar *focl-batch-mode* nil) 
(defvar *save-examples* nil) 
(defvar *always-try-cliches* nil)
(defvar *ebl-better-function* nil)
(defvar *literal-better-function* nil)
(defvar *delete-better-function* nil)
(defvar *try-all-conjunctions* nil)
(defvar *stop-when-all-pos-covered* nil)
(defvar *builtin-threshold-only* nil)
(defvar *use-relational-cliches* t)
(defvar *available-relational-cliches* '(threshold-comparator partof))
(defvar *enable-determinate-literals* nil)
(defvar *max-determinacy* 1)
(defvar *max-determinate-depth* 5)
(defvar *create-preds-from-cliches* nil)
(defvar *pos-examples-num* nil)
(defvar *neg-examples-num* nil) 
(defvar *cliches-can-have-negated-components?* nil)
(defvar *max-new-variables* 0)
(defvar *max-new-cliche-vars* 0)
(defvar *max-winners* 0)
(defvar *retain-only-all-best-winners* nil)
(defvar *trace-learning?* t)
(defvar *focl-trace-level* nil)
;; :i information gain
;; :c new clauses
;; :l new literals
;; :ct tuples for each clause
;; :lt tuples for each literal
;; :b bits
;; :o operationalization
(defvar *display-learning?* nil)
(defvar *focl-display-level* nil)
;; :current-gain
;; :best-gain
;; :ebl
;; :learned-description
;; :work
;; :pause-before-learning
;; :pause-after-clause
;; :pause-after-literal
(defvar *theory-mode* t)                  ;; ebl prefered to induction
(defvar *learned-description* nil)        ;; *learned-concept-description*
(defvar *learned-description-head* nil)   ;; *learned-concept-description-head*
(defvar *use-goal-concept* t)
(defvar *goal-concept* nil)
(defvar *remove-goal-concept-rule* nil)
(defvar *reset-hash-tables* t)
(defvar *reset-statistics* t)

(defvar *graphs* nil)
(defvar *ebl-graph* nil)
(defvar *define-rule-for-learned-description* nil)


;; -- op ----------------------------------------

(defvar *max-op-depth* 100)

(defvar *free-coverage-structs* nil)
(defvar *save-all-tuples-covered-by-each-disjunct* nil)
(defvar *relations-defined-during-learning* nil)
(defvar *print-relations-defined-during-learning* nil)
(defvar *fast-operationalization* nil)                                           ;;; retain no derivation information use op-l op-c op-d.
(defvar *conjunction-function-hash* (make-hash-table :test #'equal :size 100))


;; -- frontier-op ----------------------------------------

(defvar *all-frontier-operators* nil)
(defvar *active-frontier-operators*
  '(FRONTIER-OP_replace_node_by_one_antecedent_disjunct
    FRONTIER-OP_replace_node_by_all_but_one_antecedent_disjunct
    FRONTIER-OP_delete_one_conjunct
    FRONTIER-OP_expand_conjunctively_defined_single_node_disjunct
    FRONTIER-OP_delete_one_disjunct
    FRONTIER-OP_add_one_existing_disjunct))
(defvar *all-fast-frontier-operators* nil)
(defvar *active-fast-frontier-operators*
  '(FAST-FRONTIER-OP_replace_rule_by_one_clause
    FAST-FRONTIER-OP_replace_rule_by_all_but_one_clause
    FAST-FRONTIER-OP_delete_one_literal_from_rule
    FAST-FRONTIER-OP_delete_one_literal_from_clause
    FAST-FRONTIER-OP_delete_one_clause
    FAST-FRONTIER-OP_add_one_clause))
(defvar *frontier-look-ahead-level* 0)
(defvar *operationalize-only-when-inital-frontier-has-positive-gain* nil)
(defvar *frontier-check-for-unbound-variables* t)
(defvar *frontier-prevent-adding-deleted-disjuncts* t)
(defvar *frontier-induction* nil)
(defvar *frontier-induction-pool-tuples* nil)
(defvar *frontier-simplification* nil)
(defvar *revise-theory* nil)
(defvar *TREAT-ALL-CALLS-WITHIN-FRONTIER-INDEPENDENTLY* nil) ;;; when nil changing the definition of a rule anywhere in the frontier changes it globally
(defvar *MULTIPLE-CALLS* nil)                                ;;; goal concept contains multiple calls to the same rule  
(defvar *EXPAND-BEST-FRONTIER* t)                            ;;; after finding the best frontier completely expand it and try again


;; -- simplify-opzns ----------------------------------------

; for comparison of simplify algs
(defvar *total-deletions* nil) ; number of times optimal deletes one or more literals
(defvar *deletions-agree*) ; number of times optimal and greedy algs agree

; counts the variablizations checked during simplification
(defvar *ebl-variabilizations* 0) 

;; -- find-literal ----------------------------------------

(defvar *variabilization-hash-array* (make-hash-table :test #'equal :size 100))

;; -- cliches ----------------------------------------

(defvar *all-cliches* nil)
(defvar *cliche-variabilizations-checked* nil)
(defvar *cliches-to-be-named* nil)
(defvar *named-cliches* nil)
(defvar *anonymous-cliches* nil)

;;; cliche testing parameters

;;; domain theory testing

(defparameter *cliche-recogn-test-file-list*
  '(("illegal domain theory" "illegal" "chess-domain")
    ("student loan domain theory" "students" "loan")
    ("xmas  domain theory" "xmas")
;;;    ("trade domain theory" "trade-cases" "trade-outcomes")
    ("trade domain theory" "trade-outcomes")
;;;    ("ebr domain theory" "final-ebr-rules" "final-ebr-facts" "final-ebr-outcomes")
    ("ebr domain theory" "final-ebr-rules")
;;;    ("hughes domain theory" "hughes-rules" "hughes-facts" "hughes-outcomes")
    ("hughes domain theory" "hughes-rules")
    ("cup domain theory" "part-of-ourcup")))
    
;;; unconstrained cliche and operational definition testing parameters

(defparameter *cliche-test-files* 
  '(("part-of-ourcup") ("test-hbp-ewbc-good") ("test-non-numeric") ("test-arithmetic-cliche")
    ("recursive-member") ("recursive-length")))
(defparameter *cliche-names* 
  '(partof threshold-comparator non-numeric-constant arithmetic 
    recursive recursive2))
(defparameter *cliche-test-names* *cliche-names*)
(defparameter *cliche-test-concepts* '(cup ill red-cup a+b member length))
(defparameter *cliche-test-functions*
  '(test-cup test-foo test-red-cup test-a+b test-member test-length))

;; -- builtin ----------------------------------------

;; -- is ----------------------------------------

(defvar *builtin-fns* nil) ; we use this now

;; -- arith ----------------------------------------

(defvar *arithmetic-ops* nil)
(defvar *is-ops* nil)

;; -- testing-simp ----------------------------------------

(defvar *overfit-ratio* nil) ;;prevents overfiting

;; -- determinates ----------------------------------------

(defvar *used-gains* nil)
(defvar *used-winners* nil)
(defvar *source-priorities* '(:ebl :extensional :builtin :intensional :cliches :determinate :simplify))
(defvar *determinate-rs-and-vars* nil)
(defvar *rs-and-vars-introducing-new-vars-covering-all-pos* nil)
(defvar *rs-and-vars-introducing-new-vars* nil)

;; -- work ----------------------------------------

(defvar *status* nil)
(defparameter *literal-work* (make-work))
(defparameter *clause-work* (make-work))
(defparameter *theory-work* (make-work))

;; -- theory revision -----------------------------


;;===============================================================
;;  User Interface
;;===============================================================

(defvar *user-interface-available* nil)
(defvar *user-monitor* nil)
(defvar *load-time* nil)

(defvar *analyze-pred* nil)
(defvar *analyze-rule* nil)

;; Windows ___________________________________________

(defvar *CURRENT-GAIN-WINDOW* nil)
(defvar *BEST-GAIN-WINDOW* nil)
(defvar *EBL-WINDOW* nil)
(defvar *WORK-WINDOW* nil)
(defvar *LEARNED-DESCRIPTION-WINDOW* nil)

;; Stuff which is nice to know is bound ___________________________________________

(defvar *rules-changed* nil)
(defvar *facts-changed* nil)
(defvar *new-facts-pos* nil)
(defvar *new-facts-neg* nil)
(defvar *kb-file* nil)
(defvar *last-explanation* nil)

(defvar *focl-problem* nil)
(defvar *focl-problems* nil)
(defvar *example-templates* nil)

;; Default ES preferences ___________________________________________

(defvar *expert-mode* nil)                     ;; was t
(defvar *saved-warnings*
  #+:ccl-2 ccl::*suppress-compiler-warnings*
  #-:ccl-2 nil)
(defvar *es-suppress-compiler-warnings* t)     ;; was nil
(defvar *use-menu* t)
(defvar *edit-graphically* t)
(defvar *maintain-examples-when-editing* nil)
(defvar *retain-analysis-while-editing* nil)
(defvar *reanalyze-automatically* nil)
(defvar *map-tuples-back-to-examples* nil)
(defvar *use-templates-when-possible* t)
(defvar *color-level* nil)
(defvar *copy-graph-to* :selected-nodes)          ;; :prolog  :selected-nodes :top-selected-nodes or :pict
(defvar *permanently-record-user-responses* :ask) ;; T (save but don't ask), nil (don't save), or :ask (ask the luser)
(defvar *find-related-facts* t)

#+:ccl-2 (defvar *es-file-menu* nil)
#+:ccl-2 (defvar *es-expert-file-menu* nil)
#+:ccl-2 (defvar *es-rules-menu* nil)

#+:ccl-2 (defvar *es-type-menu* nil)
#+:ccl-2 (defvar *es-run-menu* nil)
#+:ccl-2 (defvar *es-windows-menu* nil)
#+:ccl-2 (defvar *es-display-menu* nil)
#+:ccl-2 (defvar *es-learn-menu* nil)

#+:ccl-2 (defvar *es-learning-menu* nil)

(defparameter *default-expand-depth* 2)
(defparameter *default-expand* :first-use)
;;;  :completely t   ignore expand-depth completely expand theory
;;;  :every-use      expand every-use to expand depth
;;;  :first-use      expand first-use to expand depth
;;;  :never  nil     don't expand at all