
;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold withou
;;;; written permission from the Regents of the University of California.
;;;; This program was written by Michael Pazzani, Cliff Brunk, Glenn Silverstein
;;;; and Kamal Ali.  

(in-package :user)


(defun print-focl-answer (x)
  (format t "~%::::::::~a~%" x))

(defun test-focl ()
  
  (reset-preds)
  (load-source-test-file "member")
  (time (print-rule-summary (print-focl-answer (test-member))))
  
  (reset-preds)
  (load-source-test-file "illegal")
  (time (print-rule-summary (print-focl-answer (test-illegal))))
  
  (reset-preds)
  (load-source-test-file "test-numbers")
  (time (print-rule-summary (print-focl-answer (focl 'test1))))
  (time (print-rule-summary (print-focl-answer (focl 'test2))))
  (time (print-rule-summary (print-focl-answer (focl 'test3))))
  (time (print-rule-summary (print-focl-answer (focl 'test4))))
  (time (print-rule-summary (print-focl-answer (focl 'test5))))
  
  (reset-preds)
  (load-source-test-file "illegal")
  (load-source-test-file "chess-domain")
  (time(print-rule-summary (print-focl-answer (test-illegal-ebl))))
  
  (reset-preds)
  (load-source-test-file "illegal")
  (load-source-test-file "chess-knight-and-rook")
  (print-focl-answer (judge-original 100))
  (time (print-rule-summary (print-focl-answer (test-incorrect-illegal))))
  (time(print-rule-summary (print-focl-answer (test-incorrect-illegal t)))) 
  (time (print-rule-summary (print-focl-answer (test-incorrect-illegal t :frontier))))

  (reset-preds)
  (load-source-test-file "students")
  (load-source-test-file "loan")
  (time (print-rule-summary (print-focl-answer (test-students))))
  (time (print-rule-summary (print-focl-answer (test-students-induction))))
  
  (reset-preds)
  (load-source-test-file "worse-loan")
  (time (print-rule-summary (print-focl-answer (test-students-simplify))))
  (time (print-rule-summary (print-focl-answer (test-students-simplify :frontier))))
  
  (reset-preds)
  (load-source-test-file "illegal-200")
  (time (print-rule-summary (print-focl-answer (test-200))))
  
  (reset-preds)
  (load-source-test-file "xmas")
  (time (print-rule-summary (print-focl-answer (test-xmas)))) 
  (time (print-rule-summary (print-focl-answer (test-xmas :gain-function :ratio :simplify-operationalizations
							  t :refinement :frontier
	                                                  :prefer-deletions t :prefer-children t :goal-concept-name
	                                                  'xmas-present :trace '(:i :l :c))))) 
  (test-focl-builtins)
  (test-focl-triangle)
  (test-trade)
  (test-cliches)
  (test-non-numeric-and-equality-builtins)
  (test-ebr)
  (test-kr-students)
  (test-hughes)
  
  
  (test-satellite)
  (test-breast-cancer-domain)
  ;; (test-cliche-recognition) ; ges 2/12  ; cab broken 9/92
  )

;;;  exercises builtins (and extensional/builtin predicates) and "is" 
;;;  predicates

(defun test-focl-builtins()
  ;  strongly typed version of student loan with missing rules to 
  ;  demonstrate conjunctions
  (reset-preds)
  (load-source-test-file "typed-students")
  (load-source-test-file "typed-loan")
  (time (print-rule-summary (print-focl-answer (test-students '(:i :l :b :lt)))))
  (time (print-rule-summary (print-focl-answer (test-students '(:i :l :b :lt) :frontier))))
 
  (reset-preds)
  (load-source-test-file "test-hr")
  (time (print-rule-summary (print-focl-answer (test-hr))))

  (reset-preds)
  (load-source-test-file "test-is")
  (time (print-rule-summary (print-focl-answer (test-is))))

  )

;;;  tests mostly the is feature 

(defun test-focl-triangle ()
  (reset-preds)
  (load-source-test-file "triangle")
  (load-source-test-file "test-triangle2")
  (load-source-test-file "test-triangle")
  (time (print-rule-summary (print-focl-answer (test-triangle '(:l)))))
  (format t "~%~%~% long trace for illegal input A < B only")
  (time (print-rule-summary (print-focl-answer (test-illegal-input2 '(:i :l :lt)))))
  (format t "~%~%~%long trace for equaliateral A = B only")
  (time (print-rule-summary (print-focl-answer (test-equilat2 '(:i :l :lt))))))

;;;  tests focl on 50 trade negotiation cases (stored in trade-cases.lisp - 
;;;  case outcomes are stored in trade-outcomes.lisp) with and without the
;;;  a domain theory which is 40% accurate (i.e., classifies a case as 
;;;  belonging to a unique and correct class).  There are four classes of
;;;  cases: uswin, oppwin, noagg, and tie.  
;;;  test-trade outcome is defined in trade-outcomes.lisp. Note that this
;;;  function defaults the :builtin-threshold-only flag to t (for 
;;;  compatability with the cbr system, the domain theories can't contain
;;;  comparisons between variables).

(defun test-trade ()
  (format t "~%~% Testing trade negotiation data with no domain theory")
  (reset-preds)
  (load-source-test-file "trade-cases")
  (load-source-test-file "trade-outcomes")
  (run-trade-test)
  (reset-preds)
  (load-source-test-file "trade-cases")
  (load-source-test-file "trade-outcomes")
  (load-source-test-file "trade-dt")
  (run-trade-test))

(defun run-trade-test ()
  (mapc
   #'(lambda (outcome outcome-rule)
       (format t "~% processing class ~A" outcome)
       (time (print-focl-answer (test-trade-outcome outcome '(:l) outcome-rule))))
   '(uswin oppwin tie noagg)
   '(uswin-rule oppwin-rule tie-rule noagg-rule)))

;;; cliche and non-numeric-builtin tests

;;; tests a cliche by running it using the given available-cliches supplied and
;;; comparing the results using the single unconstrained cliche

;;;    test-files - files to load 
;;;    cliche-tested - name of cliche tested (used only for print msg)
;;;    concept - concept being learned (used only for print msg)
;;;    test-fn - name of function to call note this should accept 
;;;      available-cliches as a keyword paramter and trace as an optional
;;;      parameter
;;;    trace - trace for test-fn
;;;    keys - other keywords args for test-fn

(defun test-cliche (test-files cliche-tested concept test-fn trace 
		    available-cliches 
		    &rest keys &key the-ignored-key &allow-other-keys)
  (declare (ignore the-ignored-key))
  (reset-preds)
  (mapc #'load-source-test-file test-files)
  (format t "~%~%testing ~a CLICHE on ~a~%" cliche-tested concept)
  (time (print-focl-answer (apply test-fn trace :available-cliches available-cliches keys)))
  (format t "~%~% cliche variabilizations checked: ~a ~% total variabilizations checked ~a"
	  *cliche-variabilizations-checked* *variablizations-checked* )
  (format t "~%~%testing UNCONSTRAINED CLICHE on ~a~%" concept)
  (time (print-focl-answer (apply test-fn trace :available-cliches '(unconstrained) keys)))
  (format t "~%~% cliche variabilizations checked: ~a ~% total variabilizations checked ~a"
	  *cliche-variabilizations-checked* *variablizations-checked* ))

;;; note need to update parameters of the testing function so they all can utilize conj-length
;;; and trace

(defun test-cliche-recognition (&optional trace (conj-length 2))
  ;; test out recognition on domain theories
  (format t "~%Performing cliche recognition on domain theories only~%")
  (test-cliche-recog-dt *cliche-recogn-test-file-list* conj-length)
  ;; test out recognition using unconstrained cliche instantiations
  (format t "~%Performing cliche recognition using unconstrained cliche instantiations~%")
  (test-cliche-recog-uc trace)
  ;; test-out recognition on learned concept descriptions
  (format t "~%Performing cliche recognition using learned concept descriptions~%")
  (test-cliche-recog-lcd trace))

;;;  test out available cliches - note the functionality arithmetic cliche 
;;;  is currently not supported in the unconstrained cliche

          
(defun test-cliches (&optional create-preds-from-cliches)
  (let ((all-cliches nil))
    (mapc #'(lambda (files name concept function) 
              (test-cliche files name concept function '(:l :ci) *cliche-names*
                           :create-preds-from-cliches create-preds-from-cliches)
              (if *cliches-to-be-named* 
                (setq all-cliches (append *cliches-to-be-named* all-cliches))))
          *cliche-test-files*
          *cliche-test-names*
          *cliche-test-concepts*
          *cliche-test-functions*)
    all-cliches))


#|
(defun test-cliches (&optional create-preds-from-cliches)
  (test-cliche '("part-of-ourcup") 'partof 'cup 'test-cup '(:l :ci) 
	       '(partof threshold-comparator)
               :create-preds-from-cliches create-preds-from-cliches)
  (test-cliche '("test-hbp-ewbc-good") 'threshold-comparator 'ill 'test-foo 
	       '(:l :ci) '(partof threshold-comparator)
               :create-preds-from-cliches create-preds-from-cliches)
  (test-cliche '("test-non-numeric") 'non-numeric-constant 'red-cup 
	       'test-red-cup 
	       '(:l :ci) '(non-numeric-constant)
               :create-preds-from-cliches create-preds-from-cliches)
  (format t "~%~% Note - arithmetic cliche not yet supported in unconstrained cliche~%")
  (test-cliche '("test-arithmetic-cliche") 'arithmetic 'a+b
	       'test-a+b
	       '(:l :ci) '(arithmetic)
               :create-preds-from-cliches create-preds-from-cliches)
  (test-cliche '("recursive-member") 'recursive 'member 
	       'test-member 
	       '(:l :ci) '(recursive)
               :create-preds-from-cliches create-preds-from-cliches)
  (test-cliche '("recursive-length") 'recursive2 'length 
	       'test-length 
	       '(:l :ci) '(recursive2)
               :create-preds-from-cliches create-preds-from-cliches)
)
|#
;;; tests out thresholds for non-numeric builtins and equality constants for
;;; both numeric and non-numeric equality builtins (also tests eql(A,B))

(defun test-non-numeric-and-equality-builtins ()
  (reset-preds)
  (load-source-test-file "test-non-numeric")
  (format t "~%~% testing same color (tests non-numeric equality w/o constants)")
  (time (print-focl-answer (test-same-color '(:l))))
  (reset-preds)
  (load-source-test-file "test-string-lessp")  
  (format t "~%~% testing non-numeric relations with string-lessp")
  (format t "~%~% learnings string-lessp(A,\"mouse\") - i.e., thresholds with non-numeric relations~%")
  (time (print-focl-answer (test-less-than-mouse '(:i :l))))
  (format t "~%~% testing string-lessp on just variables - learning less-strings (i.e. string-lessp(A,B))~%")
  (time (print-focl-answer (test-less-strings '(:l))))
  (reset-preds)
  (load-source-test-file "test-b=7")
  (format t "~%~%testing numeric equality concepts with B=7~%")
  (time (print-focl-answer (test-b=7 '(:l)))))

;;; tests to ensure approximately determinate literals (via maximizing coverage)
;;; are built for one satellite component failure

(defun test-satellite()
  (reset-preds)
  (load-source-test-file "test-satellite")
  (format t "~%~% testing determinate literals for faulty-asr60 (satellite)~%")
  (time (print-rule-summary (print-focl-answer (test-faulty-asr60))))
  (reset-preds)
  (format t "~%~% testing det. lits for faults involving more than 1 time series~%")
  (time (print-rule-summary (print-focl-answer (test-faulty-opfault)))))

(defun test-ebr ()
  (reset-preds)
  (load-source-test-file "final-ebr-rules")
  (load-source-test-file "final-ebr-facts")
  (load-source-test-file "final-ebr-outcomes")
  (print-focl-answer (test-trade-outcome 'SIGNIFICANT_CONCESSION-FACT nil 'SIGNIFICANT_CONCESSION))
  (print-focl-answer (test-trade-outcome 'SIGNIFICANT_CONCESSION-FACT nil nil))
  (load-source-test-file "final-ebr-negated-rules")
  (print-focl-answer (test-trade-outcome 'SIGNIFICANT_CONCESSION-FACT nil 'SIGNIFICANT_CONCESSION :frontier))
  (print-focl-answer (test-trade-outcome 'SIGNIFICANT_CONCESSION-FACT nil nil))
  (reset-preds)
  (load-source-test-file "simple-ebr-rules")
  (load-source-test-file "simple-ebr-facts")
  (load-source-test-file "simple-ebr-outcomes")
  (print-focl-answer (test-trade-outcome 'SIGNIFICANT_CONCESSION-FACT nil 'SIGNIFICANT_CONCESSION))
  (print-focl-answer (test-trade-outcome 'SIGNIFICANT_CONCESSION-FACT nil nil))
  )


(defun test-hughes ()
  (reset-preds)
  (load-source-test-file "hughes-rules")
  (load-source-test-file "hughes-facts")
  (load-source-test-file "hughes-outcomes")
  (print-focl-answer (learn-category t))
  (print-focl-answer (learn-category))
  )


(defun test-kr-students ()
  (reset-preds)
  (load-source-test-file "student-rules-incorrect")
  (load-source-test-file "student-facts")
  (def-builtin > #'> :vars (number-1 number-2))
  (focl 'no_payment_due-fact :max-new-variables 2  
	:simplify-operationalizations t
        :goal-concept-name 'no_payment_due)
  )



(defun test-cancer?()
  (focl 'cancer? 
	:max-new-variables 1
	:intensional-induction t ; ges 2/19 - was :constructive-induction
	:trace '(:c)
	:available-cliches '( non-numeric-constant)
	:max-new-cliche-vars 1
	:simplify-clauses nil
	:cliches-can-have-negated-components? nil
	))

(defun test-breast-cancer-domain()
  (reset-preds)
  (load-source-test-file "breast-cancer")
  (time (print-rule-summary (print-focl-answer (test-cancer?)))))

(defun test-promotor-domain()
  (reset-preds)
  (load-source-test-file "promotor-data")
  (load-source-test-file "promotor-rules")
  (load-source-test-file "promotor-extras")
  (time (print-rule-summary (print-focl-answer (test-promotor))))
  (time (print-rule-summary (print-focl-answer 
			     (test-promotor :goal-concept nil))))
)
  


