
;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold withou
;;;; written permission from the Regents of the University of California.
;;;; This program was written by Michael Pazzani, Cliff Brunk, Glenn Silverstien
;;;; and Kamal Ali.  

(in-package :user)

(def-rule any-size
  :vars (?object)
  :type (:object)
  :clauses ( ((any-size ?object) (small ?object))
             ((any-size ?object) (large ?object)) )
  )

(def-rule any-color
  :vars (?object)
  :type (:object)
  :clauses ( ((any-color ?object) (red ?object))
             ((any-color ?object) (green ?object))
             ((any-color ?object) (purple ?object)) )
  )

(def-rule any-shape 
  :vars (?object)
  :type (:object)
  :clauses ( ((any-shape ?object) (circle ?object))
             ((any-shape ?object) (polygon ?object)) )
  )

(def-rule polygon 
  :vars (?object)
  :type (:object)
  :clauses ( ((polygon ?object) (triangle ?object))
             ((polygon ?object) (rectangle ?object)) )
  )

(def-rule rectangle
  :vars (?object)
  :type (:object)
  :clauses(  ((rectangle ?object) (square ?object))
             ((rectangle ?object) (oblong-rectangle ?object)) )
  )

(def-rule xmas-present 
  :vars (?object)
  :type (:object)
  :clauses (((xmas-present ?object) (any-color ?object) (any-size ?object) (any-shape ?object)) )
  )

(def-pred xmas-present-fact
  :vars (?object)
  :type (:object)
  :pos ((s-g-s) (l-r-or))
  :neg ((l-r-t) (s-g-t) (s-p-s) (l-p-or)))

(def-pred small
  :vars (?object)
  :type (:object)
  :pos ((s-g-s) (s-g-t) (s-p-s)))

(def-pred large
  :vars (?object)
  :type (:object)
  :pos ((l-r-or) (l-r-t) (l-p-or)))

(def-pred green
  :vars (?object)
  :type (:object)
  :pos ((s-g-s) (s-g-t)))

(def-pred red
  :vars (?object)
  :type (:object)
  :pos ((l-r-or) (l-r-t)))

(def-pred purple
  :vars (?object)
  :type (:object)
  :pos ((s-p-s) (l-p-or)))

(def-pred square
  :vars (?object)
  :type (:object)
  :pos ((s-g-s) (s-p-s)))

(def-pred oblong-rectangle
  :vars (?object)
  :type (:object)
  :pos ((l-r-or) (l-p-or)))

(def-pred triangle
  :vars (?object)
  :type (:object)
  :pos ((l-r-t) (s-g-t)))

(def-pred circle
  :vars (?object)
  :type (:object)
  :pos ())
  
(def-example-template xmas-present-fact (?object)
  (small ?object)
  (large ?object)
  (green ?object)
  (red ?object)
  (purple ?object)
  (square ?object)
  (triangle ?object)
  (oblong-rectangle ?object)
  (circle ?object))


(def-focl-problem xmas-present-fact
  :goal-concept-name xmas-present
  )
