
;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold without
;;;; written permission from the Regents of the University of California.
;;;; This program was written by Michael Pazzani, Cliff Brunk, Glenn Silverstein
;;;; and Kamal Ali.  

#+:ccl-2 (unless (find-package :user)
           (make-package :user
                         :nicknames (list :user :focl)
                         :use (list (find-package :ccl)
                                    (find-package :common-lisp))))

(in-package :user)

#-:ccl-2 (proclaim '(optimize (safety 0)(speed 3)))
#+:ccl-2 (proclaim '(optimize (safety 3)(speed 0)))

(defparameter *test-prefix*
  #+:ccl "home:test;"
  #-:ccl "test/")

(defparameter *compiled-test-prefix*
  #+:ccl "home:compiled-test;"
  #-:ccl "compiled-test/")

;;;___________________________________
;;;  FOCL file lists

(defparameter *core-files* '("structs" "globals" "loop" "macros" "cliche-macros" 
                             "cruel-compiler" "theory-graph" "count" "utilities" "focl" "find-literal" 
                             "simplify" "stopping" "leaf-op" "fast-op" "frontier-op" "frontier-operators"
                             "determinates" "builtin" "template-induction"
                             "pruning" "variabilizations"
                             "cliches" "cliche-restrictions" "cliches-predefined"
                             "work" "dump"
                             ))

(defparameter *auxiliary-files* '("recog-cliches" "recog-pred-restr"
                                  "learning-curve" "rep" "dt-mutator" "test-focl"
                                  "testing-illegal" "noisy-testing"
                                  ;"noisy-testing-illegal" "noisy-testing-students" "testing-cancer-utils"
                                  ))

#+:ccl-2 (defparameter *interface-files* '("symbol-completion" "pict-scrap" "scrollers" "scrolling-fred-dialog-item"
                                           "selectors" "grapher" "hardcopy"
                                           "learning-window" "gain-window"
                                           "learned-description-window" "animate-learning"
                                           "modal-type-in-window" "examples-window" "analyze-coverage"
                                           "dialogs" "menus" "editor" "KR" "ES" "font-menus"
                                           ))

(defparameter *focl-defns-files* '("structs" "globals" "loop" "macros" "cliche-macros"
                                   "cruel-compiler" "cliches" "operationalize" "is"))

(defparameter *fact-and-rule-files* '("illegal" "illegal-200" "member" 
                             "loan" ; "bad-loan" this appears to be gone
                             "students" "chess-knight-and-rook"
                             "chess-domain" "test-numbers" 
                             "runtriangle"  "process-triangle"
                             "triangle-mutations"
                             "typed-students" "typed-loan" "test-hr" "test-is" ; builtin test
                             "triangle" "test-triangle" "test-triangle2" ; triangle test
                             "part-of-ourcup" "test-arithmetic-cliche" ; cliche-test
                             "test-hbp-ewbc-simp" "test-non-numeric" "recursive-member"
                             "recursive-length" 
                             "test-b=7" "test-string-lessp" ; equality and non-numeric builtin test
                             "trade-cases" "trade-dt" "trade-outcomes" ; trade negotiations test
                             "test-satellite" "testing-cancer"
                             ))

;;;___________________________________
;;;  Load Source

(defun load-source-file (directory file)
  #+:ccl (load (format nil "home:source;~a;~a.lisp" directory file))
  #-:ccl (load (format nil "source/~a/~a.lisp" directory file))
  )

(defun load-source-core-files (&optional (files *core-files*))           (mapc #'(lambda (file) (load-source-file "core" file)) files))
(defun load-source-auxiliary-files (&optional (files *auxiliary-files*)) (mapc #'(lambda (file) (load-source-file "auxiliary" file)) files))
(defun load-source-interface-files (&optional (files *interface-files*)) (mapc #'(lambda (file) (load-source-file "interface" file)) files))

(defun load-source ()
  (load-source-core-files)
  (load-source-auxiliary-files)
  (initialize-focl))


;;;___________________________________
;;;  Load Compiled

(defun load-compiled-file (directory file)
  #+:ccl       (load (format nil "home:compiled;compiled-~a;~a.fasl" directory file))
  #+:allegro   (load (format nil "compiled/compiled-~a/~a.fasl" directory file))
  #+:kcl       (load (format nil "compiled/compiled-~a/~a.o" directory file))
  #+:lucid     (load (format nil "compiled/compiled-~a/~a.sbin" directory file))
  #+:symbolics (load (format nil "compiled/compiled-~a/~a.bin" directory file))
  )

(defun load-compiled-core-files (&optional (files *core-files*))           (mapc #'(lambda (file) (load-compiled-file "core" file)) files))
(defun load-compiled-auxiliary-files (&optional (files *auxiliary-files*)) (mapc #'(lambda (file) (load-compiled-file "auxiliary" file)) files))
(defun load-compiled-interface-files (&optional (files *interface-files*)) (mapc #'(lambda (file) (load-compiled-file "interface" file)) files))

(defun load-comp ()
  (load-compiled-core-files)
  (load-compiled-auxiliary-files)
  (initialize-focl)
  #+:lucid (compiler-options :messages nil :warnings nil :undef-warnings nil)
  #+:symbolics (setq compiler:inhibit-style-warnings t))


;;;___________________________________
;;;  Compile Source

(defun compile-source-file (directory file)
  #+:ccl       (compile-file (format nil "home:source;~a;~a.lisp" directory file)
                             :output-file (format nil "home:compiled;compiled-~a;~a.fasl" directory file))
  #+:allegro   (compile-file (format nil "source/~a/~a.lisp" directory file) :output-file (format nil "compiled/compiled-~a/~a.fasl" directory file))
  #+:kcl       (compile-file (format nil "source/~a/~a.lisp" directory file) :output-file (format nil "compiled/compiled-~a/~a.o" directory file))
  #+:lucid     (compile-file (format nil "source/~a/~a.lisp" directory file) :output-file (format nil "compiled/compiled-~a/~a.sbin" directory file))
  #+:symbolics (compile-file (format nil "source/~a/~a.lisp" directory file) :output-file (format nil "compiled/compiled-~a/~a.bin" directory file))
  )

(defun compile-core-files (&optional (files *core-files*))           (mapc #'(lambda (file) (compile-source-file "core" file)) files))
(defun compile-auxiliary-files (&optional (files *auxiliary-files*)) (mapc #'(lambda (file) (compile-source-file "auxiliary" file)) files))
(defun compile-interface-files (&optional (files *interface-files*)) (mapc #'(lambda (file) (compile-source-file "interface" file)) files))

(defun compile-all ()
  (compile-core-files *core-files*)
  (compile-auxiliary-files *auxiliary-files*))

;;;___________________________________
;;;  Load Newest

(defun load-newest-file (source-file binary-file)
  (let ((source-exists (probe-file source-file))
        (binary-exists (probe-file binary-file)))
    (cond ((and source-exists binary-exists (> (file-write-date binary-file) (file-write-date source-file))) (load binary-file))
          (source-exists (load source-file))
          (binary-exists (format nil "~%Warning: Can not find source file ~A." source-file) (load binary-file))
          (t (break (format nil "Can not find source file \"~A\",~%        or compiled file \"~A\"." source-file binary-file))))))

(defun load-newest-files (directory files)
  (dolist (file files)        
    (let ((source-file #+:ccl (format nil "home:source;~a;~a.lisp" directory file)
                        #-:ccl (format nil "source/~a/~a.lisp" directory file))
           (binary-file #+:ccl       (format nil "home:compiled;compiled-~a;~a.fasl" directory file)
                        #+:allegro   (format nil "compiled/compiled-~a/~a.fasl" directory file)
                        #+:kcl       (format nil "compiled/compiled-~a/~a.o" directory file)
                        #+:lucid     (format nil "compiled/compiled-~a/~a.sbin" directory file)
                        #+:symbolics (format nil "compiled/compiled-~a/~a.bin" directory file)))
      (load-newest-file source-file binary-file))))

(defun load-newest-core-files (&optional (files *core-files*)) (load-newest-files "core" files))
(defun load-newest-auxiliary-files (&optional (files *auxiliary-files*)) (load-newest-files "auxiliary" files))
(defun load-newest-interface-files (&optional (files *interface-files*)) (load-newest-files "interface" files))

(defun load-newest ()
  (load-newest-core-files)
  (load-newest-auxiliary-files)
  (initialize-focl))


;;;___________________________________
;;;  Update - Compile and Load New Source

(defun update-file (source-file binary-file)
  (let ((source-exists (probe-file source-file))
        (binary-exists (probe-file binary-file)))
    (cond (source-exists
           (unless (and binary-exists (> (file-write-date binary-file) (file-write-date source-file)))
             (compile-file source-file :output-file binary-file)
             (load binary-file)))
          (binary-exists (format nil "~%Warning: Can not find source file ~A." source-file))
          (t (break (format nil "Can not find source file \"~A\",~%        or compiled file \"~A\"." source-file binary-file))))))

(defun update-files (directory files)
  (dolist (file files)        
    (let ((source-file #+:ccl (format nil "home:source;~a;~a.lisp" directory file)
                       #-:ccl (format nil "source/~a/~a.lisp" directory file))
          (binary-file #+:ccl       (format nil "home:compiled;compiled-~a;~a.fasl" directory file)
                       #+:allegro   (format nil "compiled/compiled-~a/~a.fasl" directory file)
                       #+:kcl       (format nil "compiled/compiled-~a/~a.o" directory file)
                       #+:lucid     (format nil "compiled/compiled-~a/~a.sbin" directory file)
                       #+:symbolics (format nil "compiled/compiled-~a/~a.bin" directory file)))
      (update-file source-file binary-file))))

(defun update-core-files (&optional (files *core-files*))           (update-files "core" files))
(defun update-auxiliary-files (&optional (files *auxiliary-files*)) (update-files "auxiliary" files))
(defun update-interface-files (&optional (files *interface-files*)) (update-files "interface" files))

(defun update-all ()
  (update-core-files)
  (update-auxiliary-files))

;;;___________________________________
;;;  Load Source Test

(defun load-source-test-file (file)
  (load (format nil "~a~a.lisp" *test-prefix* file)))

;;;___________________________________
;;;  Load Compiled Test

(defun load-compiled-test-file (file)
  #+:ccl       (load (format nil "~a~a.fasl" *compiled-test-prefix* file))
  #+:allegro   (load (format nil "~a~a.fasl" *compiled-test-prefix* file))
  #+:kcl       (load (format nil "~a~a.o" *compiled-test-prefix* file))
  #+:lucid     (load (format nil "~a~a.sbin" *compiled-test-prefix* file))
  #+:symbolics (load (format nil "~a~a.bin" *compiled-test-prefix* file))
  )

;;;___________________________________
;;;  Compile Source Test 

(defun compile-source-test-file (file)
  #+:ccl       (compile-file (format nil "~a~a.lisp" *test-prefix* file) :output-file (format nil "~a~a.fasl" *compiled-test-prefix* file))
  #+:allegro   (compile-file (format nil "~a~a.lisp" *test-prefix* file) :output-file (format nil "~a~a.fasl" *compiled-test-prefix* file))
  #+:kcl       (compile-file (format nil "~a~a.lisp" *test-prefix* file) :output-file (format nil "~a~a.o" *compiled-test-prefix* file))
  #+:lucid     (compile-file (format nil "~a~a.lisp" *test-prefix* file) :output-file (format nil "~a~a.sbin" *compiled-test-prefix* file))
  #+:symbolics (compile-file (format nil "~a~a.lisp" *test-prefix* file) :output-file (format nil "~a~a.bin" *compiled-test-prefix* file))
  )

;;;___________________________________
;;; initialize-focl

(defun initialize-focl ()
  (when (fboundp 'define-special-r-structs)
    (unless *special-r-structs*
      (define-special-r-structs)
      (install-special-r-structs))
    (when (fboundp 'ES) (ES))))


;;;=====================================================================
;;;  MCL 2.0 specific FOCL loader

#+:ccl-2 (defparameter *load-init* t)
#+:ccl-2 (defparameter *load-core* t)
#+:ccl-2 (defparameter *load-auxiliary* t)
#+:ccl-2 (defparameter *load-interface* t)
#+:ccl-2 (defparameter *load-option* :load-newest)

#+:ccl-2 (defvar *default-apple-menu-items* nil)

#+:ccl (defun full-trace () (setq *trace-print-level* (setq *trace-print-length* nil)))

;;;___________________________________
;;;  about-FOCL-1-2-3

#+:ccl-2 (defun about-FOCL-1-2-3 ()
           (let* 
             ((window-h 450)
              (window-v 230)
              (dialog
               (make-instance
                'window :window-type :double-edge-box :window-show nil
                :view-size (make-point window-h window-v) :view-position :centered
                :view-subviews
                (list 
                 (make-dialog-item
                  'static-text-dialog-item (make-point 15 10) nil "FOCL-1-2-3     version 2.0" nil
                  :view-font '("Times" 24 :SRCOR :PLAIN))
                 (make-dialog-item
                  'static-text-dialog-item (make-point 15 40) (make-point (- window-h 30) window-v)
                  "Copyright  1990,1991 by the University of California, Irvine.
This program may be freely copied, used, or modified provided
that this copyright notice is included in each copy of this code.
This program may not be sold or incorporated into another
product to be sold without written permission from
the Regents of the University of California."
                  nil :view-font '("Times" 12 :SRCOR :PLAIN))
                 (make-dialog-item
                  'static-text-dialog-item (make-point 15 145) (make-point (- window-h 30) window-v)
                  "This program was written by:
                  Michael Pazzani, Cliff Brunk,
                  Glenn Silverstein, and Kamal Ali
                  and incorporates code by Peter Norvig (Rule compiler)
                  Alex Repenning (Symbol completion)
                  and Apple Computer (Printing, etc)."
                  nil :view-font '("Times" 12 :SRCOR :PLAIN))       
                 (make-dialog-item
                  'button-dialog-item (make-point (- window-h 80) (- window-v 30)) (make-point 70 20) " OK "
                  #'(lambda (item) item (return-from-modal-dialog nil))
                  :default-button t)))))
             (modal-dialog dialog t)))

;;;___________________________________
;;;  install-about-FOCL

#+:ccl-2 (defun install-about-FOCL ()
           (let ((apple-menu-items (menu-items *apple-menu*)))
             (apply #'remove-menu-items *apple-menu* (menu-items *apple-menu*))
             (add-menu-items *apple-menu*
                             (make-instance 'menu-item
                               ;:menu-item-checked #\
                               :menu-item-title "About FOCL-1-2-3"
                               :menu-item-action #'(lambda () (about-FOCL-1-2-3))) )
             (dolist (item apple-menu-items)
               (unless (string-equal "About FOCL-1-2-3" (menu-item-title item))
                 (add-menu-items *apple-menu* item)))))

;;;______________________________________________________________________
;;;  Redefine Load and Compile-File to display file name in mini-buffer


#+:ccl-2 (defun return-file-name-string (filename)
           (let ((name (pathname-name filename))
                 (type (pathname-type filename)))
             (if (or (equalp type :UNSPECIFIC) (null type))
               (format nil "\"~A\"" name)
               (format nil "\"~A.~A\"" name type))))

#+:ccl-2 (let ((*warn-if-redefine* nil)
               (*warn-if-redefine-kernel* nil))
           
           ;;;___________________________________
           ;;;  Load
           
           (unless (fboundp 'real-load)
             (setf (symbol-function 'real-load) (symbol-function 'load)))
           (defun load (filename &rest keys &key the-ignored-key  &allow-other-keys)
             (declare (ignore the-ignored-key))
             (map-windows #'(lambda (w) (set-mini-buffer w (format nil "~%Loading ~A" (return-file-name-string filename)))) :class 'fred-window)
             (let ((*error-output*  *terminal-io*))
               (apply #'real-load filename keys))
             (map-windows #'(lambda (w) (set-mini-buffer w (format nil "~%"))) :class 'fred-window))
           
           ;;;___________________________________
           ;;;  Compile-File
           
           (unless (fboundp 'real-compile-file)
             (setf (symbol-function 'real-compile-file) (symbol-function 'compile-file)))
           (defun compile-file (filename  &rest keys &key the-ignored-key  &allow-other-keys)
             (declare (ignore the-ignored-key))
             (map-windows #'(lambda (w) (set-mini-buffer w (format nil "~%Compiling ~A" (return-file-name-string filename)))) :class 'fred-window)
             (let ((*error-output* *terminal-io*))
               (apply #'real-compile-file filename keys))
             (map-windows #'(lambda (w) (set-mini-buffer w (format nil "~%"))) :class 'fred-window))

           )

;;;___________________________________
;;; get-load-preference

#+:ccl-2 (defun get-load-preference ()
           (let* 
             ((window-h 420) (window-v 150) (x 25) (x2 210) (y 5)
              (load-dialog
               (make-instance
                'window
                :window-type :double-edge-box
                :window-show nil
                :view-size (make-point window-h window-v)
                :view-position :centered
                :view-subviews
                (list
                 (make-dialog-item 
                  'static-text-dialog-item (make-point 10 y) nil "FOCL Configuration")
                 (make-dialog-item
                  'check-box-dialog-item (make-point x (incf y 20)) nil "Init" nil
                  :check-box-checked-p *load-init* :view-nick-name :load-init)
                 (make-dialog-item
                  'check-box-dialog-item (make-point x (incf y 16)) nil "FOCL Core" nil
                  :check-box-checked-p *load-core* :view-nick-name :load-core)
                 (make-dialog-item
                  'check-box-dialog-item (make-point x (incf y 16)) nil "FOCL Auxiliary" nil
                  :check-box-checked-p *load-auxiliary* :view-nick-name :load-auxiliary)
                 (make-dialog-item
                  'check-box-dialog-item (make-point x (incf y 16)) nil "Interface" nil
                  :check-box-checked-p *load-interface* :view-nick-name :load-interface)
                 
                 (make-dialog-item 
                  'static-text-dialog-item (make-point 190 (setf y 5)) nil "Options")
                 (make-dialog-item
                  'radio-button-dialog-item (make-point x2 (incf y 20)) nil "Load Newest"
                  #'(lambda (item) (set-dialog-item-text (find-named-sibling item :default-button) " Load New "))
                  :radio-button-pushed-p (eq *load-option* :load-newest)
                  :view-nick-name :load-newest)
                 (make-dialog-item
                  'radio-button-dialog-item (make-point x2 (incf y 16)) nil "Load Source"
                  #'(lambda (item) (set-dialog-item-text (find-named-sibling item :default-button) " Load "))
                  :radio-button-pushed-p (eq *load-option* :load-source)
                  :view-nick-name :load-source)
                 (make-dialog-item
                  'radio-button-dialog-item (make-point x2 (incf y 16)) nil "Load Source and Compile"
                  #'(lambda (item) (set-dialog-item-text (find-named-sibling item :default-button) " Load/Comp "))
                  :radio-button-pushed-p (eq *load-option* :load-source-and-compile)
                  :view-nick-name :load-source-and-compile)
                 (make-dialog-item
                  'radio-button-dialog-item (make-point x2 (incf y 16)) nil "Compile New Source"
                  #'(lambda (item) (set-dialog-item-text (find-named-sibling item :default-button) " Comp New "))
                  :radio-button-pushed-p (eq *load-option* :update)
                  :view-nick-name :update)
                 (make-dialog-item
                  'radio-button-dialog-item (make-point x2 (incf y 16)) nil "Compile All Source"
                  #'(lambda (item) (set-dialog-item-text (find-named-sibling item :default-button) " Compile "))
                  :radio-button-pushed-p (eq *load-option* :compile)
                  :view-nick-name :compile)
                 (make-dialog-item
                  'button-dialog-item (make-point (- window-h 190) (- window-v 27)) (make-point 80 20)
                  (case *load-option*
                    (:load-newest " Load New ")
                    (:load-source " Load ")
                    (:load-source-and-compile " Load/Comp ")
                    (:update " Comp New ")
                    (:compile " Compile "))
                  #'(lambda (item)
                      (setf *load-init* (check-box-checked-p (find-named-sibling item :load-init))
                            *load-core* (check-box-checked-p (find-named-sibling item :load-core))
                            *load-auxiliary* (check-box-checked-p (find-named-sibling item :load-auxiliary))
                            *load-interface* (check-box-checked-p (find-named-sibling item :load-interface))
                            *load-option* (view-nick-name (pushed-radio-button (view-container item)))) 
                      (return-from-modal-dialog t))
                  :default-button t
                  :view-nick-name :default-button)
                 (make-dialog-item
                  'button-dialog-item (make-point (- window-h 95) (- window-v 27)) (make-point 80 20)
                  " Cancel "
                  #'(lambda (item) item (return-from-modal-dialog :cancel)))
                 ))))
             (modal-dialog LOAD-DIALOG t)
             ))

;;;___________________________________
;;; load-focl 

#+:ccl-2 (defun load-focl ()
           (labels 
             ((loader-load-newest ()
                (when *load-core* (load-newest-core-files *core-files*))
                (when *load-auxiliary* (load-newest-auxiliary-files *auxiliary-files*))
                (when *load-interface* (load-newest-interface-files *interface-files*)))
              (loader-load-source ()
                (when *load-core* (load-source-core-files *core-files*))
                (when *load-auxiliary* (load-source-auxiliary-files *auxiliary-files*))
                (when *load-interface* (load-source-interface-files *interface-files*)))
              (loader-compile ()
                (when *load-core* (compile-core-files *core-files*))
                (when *load-auxiliary* (compile-auxiliary-files *auxiliary-files*))
                (when *load-interface* (compile-interface-files *interface-files*)))
              (loader-update ()
                (when *load-core* (update-core-files *core-files*))
                (when *load-auxiliary* (update-auxiliary-files *auxiliary-files*))
                (when *load-interface* (update-interface-files *interface-files*)))
              (loader-load-source-and-compile ()
                (when *load-core* (load-source-core-files *core-files*) (compile-core-files *core-files*))
                (when *load-auxiliary* (load-source-auxiliary-files *auxiliary-files*) (compile-auxiliary-files *auxiliary-files*))
                (when *load-interface* (load-source-interface-files *interface-files*) (compile-interface-files *interface-files*))))
             (ccase *load-option*
               (:load-newest (when *load-init* (load "ccl:init.lisp" :if-does-not-exist nil))
                             (loader-load-newest))
               (:load-source (when *load-init* (load "ccl:init.lisp" :if-does-not-exist nil))
                             (loader-load-source))
               (:load-source-and-compile (when *load-init* (load "ccl:init.lisp" :if-does-not-exist nil))
                                         (loader-load-source-and-compile))
               (:compile (loader-compile))
               (:update (loader-update))
               )
             (when *load-core* (install-about-FOCL))
             (when *load-interface* (setf *user-interface-available* t
                                          *display-learning?* t
                                          *trace-learning?* nil))
             (initialize-focl)))

;;;___________________________________
;;; loader 

#+:ccl-2 (defvar *auto-load-focl* t)

#+:ccl-2 (defun loader ()
           (set-window-package *top-listener* (find-package :user))
           (setf *package* (find-package :user))
           (if *auto-load-focl*
             (setf *auto-load-focl* nil)
             (get-load-preference))
           (load-focl)
           (load-focl-1-2-3-update)
           (values))

;;;___________________________________
;;; make-focl-application

#+:ccl-2 (defun make-focl-application (&optional (name "home:;FOCL-1-2-3"))
           (save-application name :creator 'FOCL))

#+:ccl-2 (window-select *top-listener*)
#+:ccl-2 (CCL::eval-enqueue '(loader))


;;;___________________________________
;;; load-focl-1-2-3-update

#+:ccl-2 (defun load-focl-1-2-3-update ()
           (when (probe-file "home:FOCL-1-2-3-update")
             (load "home:FOCL-1-2-3-update")))

#+:ccl-2 (pushnew 'load-focl-1-2-3-update *lisp-startup-functions*)


