;;; -*- Mode:Common-Lisp; Package:USER; Base:10 -*-

;;; The following knowledge base is provided courtesy of Dr. Stanley Tuhrim
;;; of Mount Sinai School of Medicine, New York, and Dr. James Reggia of
;;; the University of Maryland at College Park. Their assistance is 
;;; gratefully acknowledged.

(in-package 'user)

(export '(*brules* *facts*))

(setf *domain* 'brain-diagnosis)

(setf *brules*
      '(
	; right lateral medulla

	(<- (nystagmus-type gazeev) (right-lateral-medulla present))
	(<- (nystagmus-type horiz-left) (right-lateral-medulla present))
	(<- (nystagmus-type horiz-right) (right-lateral-medulla present))
	(<- (nystagmus-type vertical-upbeat) (right-lateral-medulla present))
	(<- (nystagmus-type vertical-downbeat) (right-lateral-medulla present))
	(<- (nystagmus-type rotatory) (right-lateral-medulla present))
	(<- (abnpupils-side-type right-miosis) (right-lateral-medulla present))
	(<- (ptosis-side right) (right-lateral-medulla present))
	(<- (facenumb-side right) (right-lateral-medulla present))
	(<- (facenumb-side left) (right-lateral-medulla present))
	(<- (swallow-severity partial) (right-lateral-medulla present))
	(<- (swallow-severity unable) (right-lateral-medulla present))
	(<- (gag-severity impaired) (right-lateral-medulla present))
	(<- (gag-severity absent) (right-lateral-medulla present))
	(<- (ataxia-type truncal) (right-lateral-medulla present))
	(<- (ataxia-type limb-right-mild) (right-lateral-medulla present))
	(<- (ataxia-type limb-right-severe) (right-lateral-medulla present))
	(<- (decram-side right-mild) (right-lateral-medulla present))
	(<- (decram-side right-severe) (right-lateral-medulla present))
	(<- (gait-type unsteady) (right-lateral-medulla present))
	(<- (gait-type other) (right-lateral-medulla present))
	(<- (pp-side left-mild) (right-lateral-medulla present))
	(<- (pp-side left-moderate) (right-lateral-medulla present))
	(<- (pp-side left-severe) (right-lateral-medulla present))
	(<- (temp-side left) (right-lateral-medulla present))

	; left lateral medulla

	(<- (nystagmus-type gazeev) (left-lateral-medulla present))
	(<- (nystagmus-type horiz-left) (left-lateral-medulla present))
	(<- (nystagmus-type horiz-right) (left-lateral-medulla present))
	(<- (nystagmus-type vertical-upbeat) (left-lateral-medulla present))
	(<- (nystagmus-type vertical-downbeat) (left-lateral-medulla present))
	(<- (nystagmus-type rotatory) (left-lateral-medulla present))
	(<- (abnpupils-side-type left-miosis) (left-lateral-medulla present))
	(<- (ptosis-side left) (left-lateral-medulla present))
	(<- (facenumb-side right) (left-lateral-medulla present))
	(<- (facenumb-side left) (left-lateral-medulla present))
	(<- (swallow-severity partial) (left-lateral-medulla present))
	(<- (swallow-severity unable) (left-lateral-medulla present))
	(<- (gag-severity impaired) (left-lateral-medulla present))
	(<- (gag-severity absent) (left-lateral-medulla present))
	(<- (ataxia-type truncal) (left-lateral-medulla present))
	(<- (ataxia-type limb-left-mild) (left-lateral-medulla present))
	(<- (ataxia-type limb-left-severe) (left-lateral-medulla present))
	(<- (decram-side left-mild) (left-lateral-medulla present))
	(<- (decram-side left-severe) (left-lateral-medulla present))
	(<- (gait-type unsteady) (left-lateral-medulla present))
	(<- (gait-type other) (left-lateral-medulla present))
	(<- (pp-side right-mild) (left-lateral-medulla present))
	(<- (pp-side right-moderate) (left-lateral-medulla present))
	(<- (pp-side right-severe) (left-lateral-medulla present))
	(<- (temp-side right) (left-lateral-medulla present))
	
	; right medial medulla

	(<- (nystagmus-type gazeev) (right-medial-medulla present))
	(<- (nystagmus-type vertical-upbeat) (right-medial-medulla present))
	(<- (nystagmus-type vertical-downbeat) (right-medial-medulla present))
	(<- (tongweak-side right) (right-medial-medulla present))
	(<- (tongweak-side left) (right-medial-medulla present))
	(<- (dysarthria-severity mild) (right-medial-medulla present))
	(<- (dysarthria-severity moderate) (right-medial-medulla present))
	(<- (dysarthria-severity severe) (right-medial-medulla present))
	(<- (weakness-type hemiparesis-left) (right-medial-medulla present))
	(<- (abndtrs-side left-incdtr) (right-medial-medulla present))
	(<- (abndtrs-side left-decdtr) (right-medial-medulla present))
	(<- (babs-side left) (right-medial-medulla present))
	(<- (gait-type lhemi) (right-medial-medulla present))
	(<- (gait-type unsteady) (right-medial-medulla present))
	(<- (gait-type other) (right-medial-medulla present))
	(<- (touch-side left) (right-medial-medulla present))
	(<- (posloss-side left) (right-medial-medulla present))
	(<- (vibloss-side left) (right-medial-medulla present))
	(<- (twopoint-side left) (right-medial-medulla present))
	(<- (agraph-side left) (right-medial-medulla present))

	; left medial medulla

	(<- (nystagmus-type gazeev) (left-medial-medulla present))
	(<- (nystagmus-type vertical-upbeat) (left-medial-medulla present))
	(<- (nystagmus-type vertical-downbeat) (left-medial-medulla present))
	(<- (tongweak-side right) (left-medial-medulla present))
	(<- (tongweak-side left) (left-medial-medulla present))
	(<- (dysarthria-severity mild) (left-medial-medulla present))
	(<- (dysarthria-severity moderate) (left-medial-medulla present))
	(<- (dysarthria-severity severe) (left-medial-medulla present))
	(<- (weakness-type hemiparesis-right) (left-medial-medulla present))
	(<- (abndtrs-side right-incdtr) (left-medial-medulla present))
	(<- (abndtrs-side right-decdtr) (left-medial-medulla present))
	(<- (babs-side right) (left-medial-medulla present))
	(<- (gait-type rhemi) (left-medial-medulla present))
	(<- (gait-type unsteady) (left-medial-medulla present))
	(<- (gait-type other) (left-medial-medulla present))
	(<- (touch-side right) (left-medial-medulla present))
	(<- (posloss-side right) (left-medial-medulla present))
	(<- (vibloss-side right) (left-medial-medulla present))
	(<- (twopoint-side right) (left-medial-medulla present))
	(<- (agraph-side right) (left-medial-medulla present))

	; right pons

	(<- (decloc-degree drowsy) (right-pons present))
	(<- (decloc-degree stupor) (right-pons present))
	(<- (decloc-degree coma) (right-pons present))
	(<- (abnpupils-side-type right-miosis) (right-pons present))
	(<- (abnpupils-side-type left-miosis) (right-pons present))
	(<- (ptosis-side right) (right-pons present))
	(<- (nystagmus-type gazeev) (right-pons present))
	(<- (nystagmus-type horiz-left) (right-pons present))
	(<- (nystagmus-type horiz-right) (right-pons present))
	(<- (nystagmus-type vertical-upbeat) (right-pons present))
	(<- (nystagmus-type rotatory) (right-pons present))
	(<- (abneom-type hgaze-right) (right-pons present))
	(<- (abneom-type ino-right) (right-pons present))
	(<- (abneom-type sixthn-right) (right-pons present))
	(<- (poorokn-direction lhoriz) (right-pons present))
	(<- (poorokn-direction rhoriz) (right-pons present))
	(<- (facenumb-side right) (right-pons present))
	(<- (facial-side-type right-peripheral) (right-pons present))
	(<- (facial-side-type left-central) (right-pons present))
	(<- (swallow-severity partial) (right-pons present))
	(<- (swallow-severity unable) (right-pons present))
	(<- (gag-severity impaired) (right-pons present))
	(<- (gag-severity absent) (right-pons present))
	(<- (dysarthria-severity mild) (right-pons present))
	(<- (dysarthria-severity moderate) (right-pons present))
	(<- (dysarthria-severity severe) (right-pons present))
	(<- (tongweak-side left) (right-pons present))
	(<- (ataxia-type limb-right-mild) (right-pons present))
	(<- (ataxia-type limb-right-severe) (right-pons present))
	(<- (weakness-type hemiparesis-left) (right-pons present))
	(<- (babs-side left) (right-pons present))
	(<- (abndtrs-side left-incdtr) (right-pons present))
	(<- (abndtrs-side left-decdtr) (right-pons present))
	(<- (gait-type lhemi) (right-pons present))
	(<- (gait-type unsteady) (right-pons present))
	(<- (gait-type other) (right-pons present))
	(<- (pp-side left-mild) (right-pons present))
	(<- (pp-side left-moderate) (right-pons present))
	(<- (pp-side left-severe) (right-pons present))
	(<- (touch-side left) (right-pons present))
	(<- (temp-side left) (right-pons present))
	(<- (posloss-side left) (right-pons present))
	(<- (vibloss-side left) (right-pons present))
	(<- (twopoint-side left) (right-pons present))
	(<- (agraph-side left) (right-pons present))

	; left pons

	(<- (decloc-degree drowsy) (left-pons present))
	(<- (decloc-degree stupor) (left-pons present))
	(<- (decloc-degree coma) (left-pons present))
	(<- (abnpupils-side-type right-miosis) (left-pons present))
	(<- (abnpupils-side-type left-miosis) (left-pons present))
	(<- (ptosis-side left) (left-pons present))
	(<- (nystagmus-type gazeev) (left-pons present))
	(<- (nystagmus-type horiz-left) (left-pons present))
	(<- (nystagmus-type horiz-right) (left-pons present))
	(<- (nystagmus-type vertical-upbeat) (left-pons present))
	(<- (nystagmus-type rotatory) (left-pons present))
	(<- (abneom-type hgaze-left) (left-pons present))
	(<- (abneom-type ino-left) (left-pons present))
	(<- (abneom-type sixthn-left) (left-pons present))
	(<- (poorokn-direction lhoriz) (left-pons present))
	(<- (poorokn-direction rhoriz) (left-pons present))
	(<- (facenumb-side left) (left-pons present))
	(<- (facial-side-type left-peripheral) (left-pons present))
	(<- (facial-side-type right-central) (left-pons present))
	(<- (swallow-severity partial) (left-pons present))
	(<- (swallow-severity unable) (left-pons present))
	(<- (gag-severity impaired) (left-pons present))
	(<- (gag-severity absent) (left-pons present))
	(<- (dysarthria-severity mild) (left-pons present))
	(<- (dysarthria-severity moderate) (left-pons present))
	(<- (dysarthria-severity severe) (left-pons present))
	(<- (tongweak-side right) (left-pons present))
	(<- (ataxia-type limb-left-mild) (left-pons present))
	(<- (ataxia-type limb-left-severe) (left-pons present))
	(<- (weakness-type hemiparesis-right) (left-pons present))
	(<- (babs-side right) (left-pons present))
	(<- (abndtrs-side right-incdtr) (left-pons present))
	(<- (abndtrs-side right-decdtr) (left-pons present))
	(<- (gait-type rhemi) (left-pons present))
	(<- (gait-type unsteady) (left-pons present))
	(<- (gait-type other) (left-pons present))
	(<- (pp-side right-mild) (left-pons present))
	(<- (pp-side right-moderate) (left-pons present))
	(<- (pp-side right-severe) (left-pons present))
	(<- (touch-side right) (left-pons present))
	(<- (temp-side right) (left-pons present))
	(<- (posloss-side right) (left-pons present))
	(<- (vibloss-side right) (left-pons present))
	(<- (twopoint-side right) (left-pons present))
	(<- (agraph-side right) (left-pons present))

	; right midbrain

	(<- (decloc-degree coma) (right-midbrain present))
	(<- (decloc-degree drowsy) (right-midbrain present))
	(<- (decloc-degree stupor) (right-midbrain present))
	(<- (disoriented-degree mild) (right-midbrain present))
	(<- (disoriented-degree moderate) (right-midbrain present))
	(<- (disoriented-degree severe) (right-midbrain present))
	(<- (cogabn present) (right-midbrain present))
	(<- (nystagmus-type gazeev) (right-midbrain present))
	(<- (nystagmus-type horiz-left) (right-midbrain present))
	(<- (nystagmus-type horiz-right) (right-midbrain present))
	(<- (nystagmus-type vertical-upbeat) (right-midbrain present))
	(<- (nystagmus-type vertical-downbeat) (right-midbrain present))
	(<- (nystagmus-type rotatory) (right-midbrain present))
	(<- (poorokn-direction lhoriz) (right-midbrain present))
	(<- (poorokn-direction vertical) (right-midbrain present))
	(<- (abnpupils-side-type right-mydriasis) (right-midbrain present))
	(<- (abnpupils-side-type right-miosis) (right-midbrain present))
	(<- (prd-side right) (right-midbrain present))
	(<- (abneom-type vgaze-up) (right-midbrain present))
	(<- (abneom-type vgaze-down) (right-midbrain present))
	(<- (abneom-type ino-right) (right-midbrain present))
	(<- (abneom-type thirdn-right) (right-midbrain present))
	(<- (abneom-type skew) (right-midbrain present))
	(<- (ptosis-side right) (right-midbrain present))
	(<- (ptosis-side left) (right-midbrain present))
	(<- (facenumb-side left) (right-midbrain present))
	(<- (facial-side-type left-central) (right-midbrain present))
	(<- (swallow-severity partial) (right-midbrain present))
	(<- (swallow-severity unable) (right-midbrain present))
	(<- (gag-severity impaired) (right-midbrain present))
	(<- (gag-severity absent) (right-midbrain present))
	(<- (weakness-type hemiparesis-left) (right-midbrain present))
	(<- (ataxia-type limb-left-mild) (right-midbrain present))
	(<- (ataxia-type limb-left-severe) (right-midbrain present))
	(<- (ataxia-type limb-right-mild) (right-midbrain present))
	(<- (ataxia-type limb-right-severe) (right-midbrain present))
	(<- (decram-side left-mild) (right-midbrain present))
	(<- (decram-side left-severe) (right-midbrain present))
	(<- (babs-side left) (right-midbrain present))
	(<- (abndtrs-side left-incdtr) (right-midbrain present))
	(<- (abndtrs-side left-decdtr) (right-midbrain present))
	(<- (gait-type lhemi) (right-midbrain present))
	(<- (gait-type unsteady) (right-midbrain present))
	(<- (gait-type other) (right-midbrain present))
	(<- (dss-side left) (right-midbrain present))
	(<- (pp-side left-mild) (right-midbrain present))
	(<- (pp-side left-moderate) (right-midbrain present))
	(<- (pp-side left-severe) (right-midbrain present))
	(<- (touch-side left) (right-midbrain present))
	(<- (temp-side left) (right-midbrain present))
	(<- (posloss-side left) (right-midbrain present))
	(<- (vibloss-side left) (right-midbrain present))
	(<- (twopoint-side left) (right-midbrain present))
	(<- (agraph-side left) (right-midbrain present))

	; left midbrain

	(<- (decloc-degree coma) (left-midbrain present))
	(<- (decloc-degree drowsy) (left-midbrain present))
	(<- (decloc-degree stupor) (left-midbrain present))
	(<- (disoriented-degree mild) (left-midbrain present))
	(<- (disoriented-degree moderate) (left-midbrain present))
	(<- (disoriented-degree severe) (left-midbrain present))
	(<- (cogabn present) (left-midbrain present))
	(<- (nystagmus-type gazeev) (left-midbrain present))
	(<- (nystagmus-type horiz-left) (left-midbrain present))
	(<- (nystagmus-type horiz-right) (left-midbrain present))
	(<- (nystagmus-type vertical-upbeat) (left-midbrain present))
	(<- (nystagmus-type vertical-downbeat) (left-midbrain present))
	(<- (nystagmus-type rotatory) (left-midbrain present))
	(<- (poorokn-direction rhoriz) (left-midbrain present))
	(<- (poorokn-direction vertical) (left-midbrain present))
	(<- (abnpupils-side-type left-mydriasis) (left-midbrain present))
	(<- (abnpupils-side-type left-miosis) (left-midbrain present))
	(<- (prd-side left) (left-midbrain present))
	(<- (abneom-type vgaze-up) (left-midbrain present))
	(<- (abneom-type vgaze-down) (left-midbrain present))
	(<- (abneom-type ino-left) (left-midbrain present))
	(<- (abneom-type thirdn-left) (left-midbrain present))
	(<- (abneom-type skew) (left-midbrain present))
	(<- (ptosis-side right) (left-midbrain present))
	(<- (ptosis-side left) (left-midbrain present))
	(<- (facenumb-side right) (left-midbrain present))
	(<- (facial-side-type right-central) (left-midbrain present))
	(<- (swallow-severity partial) (left-midbrain present))
	(<- (swallow-severity unable) (left-midbrain present))
	(<- (gag-severity impaired) (left-midbrain present))
	(<- (gag-severity absent) (left-midbrain present))
	(<- (weakness-type hemiparesis-right) (left-midbrain present))
	(<- (ataxia-type limb-left-mild) (left-midbrain present))
	(<- (ataxia-type limb-left-severe) (left-midbrain present))
	(<- (ataxia-type limb-right-mild) (left-midbrain present))
	(<- (ataxia-type limb-right-severe) (left-midbrain present))
	(<- (decram-side right-mild) (left-midbrain present))
	(<- (decram-side right-severe) (left-midbrain present))
	(<- (babs-side right) (left-midbrain present))
	(<- (abndtrs-side right-incdtr) (left-midbrain present))
	(<- (abndtrs-side right-decdtr) (left-midbrain present))
	(<- (gait-type rhemi) (left-midbrain present))
	(<- (gait-type unsteady) (left-midbrain present))
	(<- (gait-type other) (left-midbrain present))
	(<- (dss-side right) (left-midbrain present))
	(<- (pp-side right-mild) (left-midbrain present))
	(<- (pp-side right-moderate) (left-midbrain present))
	(<- (pp-side right-severe) (left-midbrain present))
	(<- (touch-side right) (left-midbrain present))
	(<- (temp-side right) (left-midbrain present))
	(<- (posloss-side right) (left-midbrain present))
	(<- (vibloss-side right) (left-midbrain present))
	(<- (twopoint-side right) (left-midbrain present))
	(<- (agraph-side right) (left-midbrain present))

	; right cerebellar hemisphere

	(<- (nystagmus-type gazeev) (right-cerebellar-hemisphere present))
	(<- (nystagmus-type horiz-left) (right-cerebellar-hemisphere present))
	(<- (nystagmus-type horiz-right) (right-cerebellar-hemisphere present))
	(<- (nystagmus-type rotatory) (right-cerebellar-hemisphere present))
	(<- (dysarthria-severity mild) (right-cerebellar-hemisphere present))
	(<- (dysarthria-severity moderate) (right-cerebellar-hemisphere present))
	(<- (dysarthria-severity severe) (right-cerebellar-hemisphere present))
	(<- (ataxia-type limb-right-mild) (right-cerebellar-hemisphere present))
	(<- (ataxia-type limb-right-severe) (right-cerebellar-hemisphere present))
	(<- (decram-side right-mild) (right-cerebellar-hemisphere present))
	(<- (decram-side right-severe) (right-cerebellar-hemisphere present))
	(<- (gait-type unsteady) (right-cerebellar-hemisphere present))
	(<- (gait-type other) (right-cerebellar-hemisphere present))
	
	; left cerebellar hemisphere

	(<- (nystagmus-type gazeev) (left-cerebellar-hemisphere present))
	(<- (nystagmus-type horiz-left) (left-cerebellar-hemisphere present))
	(<- (nystagmus-type horiz-right) (left-cerebellar-hemisphere present))
	(<- (nystagmus-type rotatory) (left-cerebellar-hemisphere present))
	(<- (dysarthria-severity mild) (left-cerebellar-hemisphere present))
	(<- (dysarthria-severity moderate) (left-cerebellar-hemisphere present))
	(<- (dysarthria-severity severe) (left-cerebellar-hemisphere present))
	(<- (ataxia-type limb-left-mild) (left-cerebellar-hemisphere present))
	(<- (ataxia-type limb-left-severe) (left-cerebellar-hemisphere present))
	(<- (decram-side left-mild) (left-cerebellar-hemisphere present))
	(<- (decram-side left-severe) (left-cerebellar-hemisphere present))
	(<- (gait-type unsteady) (left-cerebellar-hemisphere present))
	(<- (gait-type other) (left-cerebellar-hemisphere present))

	; cerebellar vermis

	(<- (nystagmus-type gazeev) (cerebellar-vermis present))
	(<- (nystagmus-type horiz-left) (cerebellar-vermis present))
	(<- (nystagmus-type horiz-right) (cerebellar-vermis present))
	(<- (nystagmus-type vertical-upbeat) (cerebellar-vermis present))
	(<- (nystagmus-type vertical-downbeat) (cerebellar-vermis present))
	(<- (nystagmus-type rotatory) (cerebellar-vermis present))
	(<- (ataxia-type truncal) (cerebellar-vermis present))
	(<- (gait-type unsteady) (cerebellar-vermis present))

	; right thalamus

	(<- (vf-deficit-side-type left-hemianopsia) (right-thalamus present))
	(<- (vf-deficit-side-type left-quadrantanopsia-inferior) (right-thalamus present))
	(<- (vf-deficit-side-type left-quadrantanopsia-superior) (right-thalamus present))
	(<- (facenumb-side left) (right-thalamus present))
	(<- (abneom-type hgaze-left) (right-thalamus present))
	(<- (abneom-type hgaze-right) (right-thalamus present))
	(<- (ataxia-type limb-left-mild) (right-thalamus present))
	(<- (ataxia-type limb-left-severe) (right-thalamus present))
	(<- (pp-side left-mild) (right-thalamus present))
	(<- (pp-side left-moderate) (right-thalamus present))
	(<- (pp-side left-severe) (right-thalamus present))
	(<- (touch-side left) (right-thalamus present))
	(<- (temp-side left) (right-thalamus present))
	(<- (posloss-side left) (right-thalamus present))
	(<- (vibloss-side left) (right-thalamus present))
	(<- (twopoint-side left) (right-thalamus present))
	(<- (agraph-side left) (right-thalamus present))

	; left thalamus

	(<- (anomia-severity mild) (left-thalamus present))
	(<- (anomia-severity moderate) (left-thalamus present))
	(<- (anomia-severity severe) (left-thalamus present))
	(<- (compdef-severity mild) (left-thalamus present))
	(<- (compdef-severity moderate) (left-thalamus present))
	(<- (compdef-severity severe) (left-thalamus present))
	(<- (vf-deficit-side-type left-hemianopsia) (left-thalamus present))
	(<- (vf-deficit-side-type left-quadrantanopsia-inferior) (left-thalamus present))
	(<- (vf-deficit-side-type left-quadrantanopsia-superior) (left-thalamus present))
	(<- (facenumb-side right) (left-thalamus present))
	(<- (abneom-type hgaze-left) (left-thalamus present))
	(<- (abneom-type hgaze-right) (left-thalamus present))
	(<- (ataxia-type limb-right-mild) (left-thalamus present))
	(<- (ataxia-type limb-right-severe) (left-thalamus present))
	(<- (pp-side right-mild) (left-thalamus present))
	(<- (pp-side right-moderate) (left-thalamus present))
	(<- (pp-side right-severe) (left-thalamus present))
	(<- (touch-side right) (left-thalamus present))
	(<- (temp-side right) (left-thalamus present))
	(<- (posloss-side right) (left-thalamus present))
	(<- (vibloss-side right) (left-thalamus present))
	(<- (twopoint-side right) (left-thalamus present))
	(<- (agraph-side right) (left-thalamus present))

	; right basal ganglia

	(<- (decloc-degree drowsy) (right-basal-ganglia present))
	(<- (cogabn present) (right-basal-ganglia present))
	(<- (decram-side left-mild) (right-basal-ganglia present))
	(<- (decram-side left-severe) (right-basal-ganglia present))
	(<- (gait-type other) (right-basal-ganglia present))

	; left basal ganglia

	(<- (decloc-degree drowsy) (left-basal-ganglia present))
	(<- (cogabn present) (left-basal-ganglia present))
	(<- (decram-side right-mild) (left-basal-ganglia present))
	(<- (decram-side right-severe) (left-basal-ganglia present))
	(<- (gait-type other) (left-basal-ganglia present))

	; right internal capsule

	(<- (facenumb-side left) (right-internal-capsule present))
	(<- (facial-side-type left-central) (right-internal-capsule present))
	(<- (tongweak-side left) (right-internal-capsule present))
	(<- (swallow-severity partial) (right-internal-capsule present))
	(<- (swallow-severity unable) (right-internal-capsule present))
	(<- (gag-severity impaired) (right-internal-capsule present))
	(<- (gag-severity absent) (right-internal-capsule present))
	(<- (dysarthria-severity mild) (right-internal-capsule present))
	(<- (dysarthria-severity moderate) (right-internal-capsule present))
	(<- (dysarthria-severity severe) (right-internal-capsule present))
	(<- (weakness-type hemiparesis-left) (right-internal-capsule present))
	(<- (weakness-type monoparesis-lue) (right-internal-capsule present))
	(<- (weakness-type monoparesis-lle) (right-internal-capsule present))
	(<- (decram-side left-mild) (right-internal-capsule present))
	(<- (decram-side left-severe) (right-internal-capsule present))
	(<- (babs-side left) (right-internal-capsule present))
	(<- (abndtrs-side left-incdtr) (right-internal-capsule present))
	(<- (abndtrs-side left-decdtr) (right-internal-capsule present))
	(<- (gait-type lhemi) (right-internal-capsule present))
	(<- (gait-type other) (right-internal-capsule present))
	(<- (dss-side left) (right-internal-capsule present))
	(<- (pp-side left-mild) (right-internal-capsule present))
	(<- (pp-side left-moderate) (right-internal-capsule present))
	(<- (pp-side left-severe) (right-internal-capsule present))
	(<- (touch-side left) (right-internal-capsule present))
	(<- (temp-side left) (right-internal-capsule present))
	(<- (posloss-side left) (right-internal-capsule present))
	(<- (vibloss-side left) (right-internal-capsule present))
	(<- (twopoint-side left) (right-internal-capsule present))
	(<- (agraph-side left) (right-internal-capsule present))

	; left internal capsule

	(<- (facenumb-side right) (left-internal-capsule present))
	(<- (facial-side-type right-central) (left-internal-capsule present))
	(<- (tongweak-side right) (left-internal-capsule present))
	(<- (swallow-severity partial) (left-internal-capsule present))
	(<- (swallow-severity unable) (left-internal-capsule present))
	(<- (gag-severity impaired) (left-internal-capsule present))
	(<- (gag-severity absent) (left-internal-capsule present))
	(<- (dysarthria-severity mild) (left-internal-capsule present))
	(<- (dysarthria-severity moderate) (left-internal-capsule present))
	(<- (dysarthria-severity severe) (left-internal-capsule present))
	(<- (weakness-type hemiparesis-right) (left-internal-capsule present))
	(<- (weakness-type monoparesis-rue) (left-internal-capsule present))
	(<- (weakness-type monoparesis-rle) (left-internal-capsule present))
	(<- (decram-side right-mild) (left-internal-capsule present))
	(<- (decram-side right-severe) (left-internal-capsule present))
	(<- (babs-side right) (left-internal-capsule present))
	(<- (abndtrs-side right-incdtr) (left-internal-capsule present))
	(<- (abndtrs-side right-decdtr) (left-internal-capsule present))
	(<- (gait-type rhemi) (left-internal-capsule present))
	(<- (gait-type other) (left-internal-capsule present))
	(<- (dss-side right) (left-internal-capsule present))
	(<- (pp-side right-mild) (left-internal-capsule present))
	(<- (pp-side right-moderate) (left-internal-capsule present))
	(<- (pp-side right-severe) (left-internal-capsule present))
	(<- (touch-side right) (left-internal-capsule present))
	(<- (temp-side right) (left-internal-capsule present))
	(<- (posloss-side right) (left-internal-capsule present))
	(<- (vibloss-side right) (left-internal-capsule present))
	(<- (twopoint-side right) (left-internal-capsule present))
	(<- (agraph-side right) (left-internal-capsule present))

	; right frontal lobe
	
	(<- (decloc-degree drowsy) (right-frontal-lobe present))
	(<- (decloc-degree stupor) (right-frontal-lobe present))
	(<- (decloc-degree coma) (right-frontal-lobe present))
	(<- (disoriented-degree mild) (right-frontal-lobe present))
	(<- (disoriented-degree moderate) (right-frontal-lobe present))
	(<- (disoriented-degree severe) (right-frontal-lobe present))
	(<- (dyspraxia present) (right-frontal-lobe present))
	(<- (hemineglect-side left) (right-frontal-lobe present))
	(<- (denial present) (right-frontal-lobe present))
	(<- (compdef-severity mild) (right-frontal-lobe present))
	(<- (nonfluency-severity mild) (right-frontal-lobe present))
	(<- (nonfluency-severity moderate) (right-frontal-lobe present))
	(<- (nonfluency-severity severe) (right-frontal-lobe present))
	(<- (repetition-severity mild) (right-frontal-lobe present))
	(<- (repetition-severity moderate) (right-frontal-lobe present))
	(<- (repetition-severity severe) (right-frontal-lobe present))
	(<- (anomia-severity mild) (right-frontal-lobe present))
	(<- (anomia-severity moderate) (right-frontal-lobe present))
	(<- (anomia-severity severe) (right-frontal-lobe present))
	(<- (cogabn present) (right-frontal-lobe present))
	(<- (dysarthria-severity mild) (right-frontal-lobe present))
	(<- (dysarthria-severity moderate) (right-frontal-lobe present))
	(<- (dysarthria-severity severe) (right-frontal-lobe present))
	(<- (poorokn-direction lhoriz) (right-frontal-lobe present))
	(<- (nystagmus-type gazeev) (right-frontal-lobe present))
	(<- (abneom-type hgaze-left) (right-frontal-lobe present))
	(<- (facial-side-type left-central) (right-frontal-lobe present))
	(<- (swallow-severity partial) (right-frontal-lobe present))
	(<- (swallow-severity unable) (right-frontal-lobe present))
	(<- (gag-severity impaired) (right-frontal-lobe present))
	(<- (gag-severity absent) (right-frontal-lobe present))
	(<- (tongweak-side left) (right-frontal-lobe present))
	(<- (weakness-type hemiparesis-left) (right-frontal-lobe present))
	(<- (weakness-type monoparesis-lue) (right-frontal-lobe present))
	(<- (weakness-type monoparesis-lle) (right-frontal-lobe present))
	(<- (decram-side left-mild) (right-frontal-lobe present))
	(<- (decram-side left-severe) (right-frontal-lobe present))
	(<- (gait-type lhemi) (right-frontal-lobe present))
	(<- (gait-type unsteady) (right-frontal-lobe present))
	(<- (gait-type other) (right-frontal-lobe present))
	(<- (ataxia-type limb-left-mild) (right-frontal-lobe present))
	(<- (abndtrs-side left-incdtr) (right-frontal-lobe present))
	(<- (abndtrs-side left-decdtr) (right-frontal-lobe present))
	(<- (babs-side left) (right-frontal-lobe present))

	; left frontal lobe
	
	(<- (decloc-degree drowsy) (left-frontal-lobe present))
	(<- (decloc-degree stupor) (left-frontal-lobe present))
	(<- (decloc-degree coma) (left-frontal-lobe present))
	(<- (disoriented-degree mild) (left-frontal-lobe present))
	(<- (disoriented-degree moderate) (left-frontal-lobe present))
	(<- (disoriented-degree severe) (left-frontal-lobe present))
	(<- (dyspraxia present) (left-frontal-lobe present))
	(<- (hemineglect-side right) (left-frontal-lobe present))
	(<- (denial present) (left-frontal-lobe present))
	(<- (compdef-severity mild) (left-frontal-lobe present))
	(<- (compdef-severity moderate) (left-frontal-lobe present))
	(<- (compdef-severity severe) (left-frontal-lobe present))
	(<- (nonfluency-severity mild) (left-frontal-lobe present))
	(<- (nonfluency-severity moderate) (left-frontal-lobe present))
	(<- (nonfluency-severity severe) (left-frontal-lobe present))
	(<- (repetition-severity mild) (left-frontal-lobe present))
	(<- (repetition-severity moderate) (left-frontal-lobe present))
	(<- (repetition-severity severe) (left-frontal-lobe present))
	(<- (anomia-severity mild) (left-frontal-lobe present))
	(<- (anomia-severity moderate) (left-frontal-lobe present))
	(<- (anomia-severity severe) (left-frontal-lobe present))
	(<- (cogabn present) (left-frontal-lobe present))
	(<- (dysarthria-severity mild) (left-frontal-lobe present))
	(<- (dysarthria-severity moderate) (left-frontal-lobe present))
	(<- (dysarthria-severity severe) (left-frontal-lobe present))
	(<- (poorokn-direction rhoriz) (left-frontal-lobe present))
	(<- (nystagmus-type horiz-right) (left-frontal-lobe present))
	(<- (abneom-type hgaze-right) (left-frontal-lobe present))
	(<- (facial-side-type right-central) (left-frontal-lobe present))
	(<- (swallow-severity partial) (left-frontal-lobe present))
	(<- (swallow-severity unable) (left-frontal-lobe present))
	(<- (gag-severity impaired) (left-frontal-lobe present))
	(<- (gag-severity absent) (left-frontal-lobe present))
	(<- (tongweak-side right) (left-frontal-lobe present))
	(<- (weakness-type hemiparesis-right) (left-frontal-lobe present))
	(<- (weakness-type monoparesis-lue) (left-frontal-lobe present))
	(<- (weakness-type monoparesis-lle) (left-frontal-lobe present))
	(<- (decram-side right-mild) (left-frontal-lobe present))
	(<- (decram-side right-severe) (left-frontal-lobe present))
	(<- (gait-type rhemi) (left-frontal-lobe present))
	(<- (gait-type unsteady) (left-frontal-lobe present))
	(<- (gait-type other) (left-frontal-lobe present))
	(<- (ataxia-type limb-right-mild) (left-frontal-lobe present))
	(<- (abndtrs-side right-incdtr) (left-frontal-lobe present))
	(<- (abndtrs-side right-decdtr) (left-frontal-lobe present))
	(<- (babs-side right) (left-frontal-lobe present))

	; right parietal lobe
	
	(<- (decloc-degree drowsy) (right-parietal-lobe present))
	(<- (decloc-degree stupor) (right-parietal-lobe present))
	(<- (decloc-degree coma) (right-parietal-lobe present))
	(<- (disoriented-degree mild) (right-parietal-lobe present))
	(<- (disoriented-degree moderate) (right-parietal-lobe present))
	(<- (disoriented-degree severe) (right-parietal-lobe present))
	(<- (dyspraxia present) (right-parietal-lobe present))
	(<- (denial present) (right-parietal-lobe present))
	(<- (hemineglect-side left) (right-parietal-lobe present))
	(<- (cogabn present) (right-parietal-lobe present))
	(<- (vf-deficit-side-type left-hemianopsia) (right-parietal-lobe present))
	(<- (vf-deficit-side-type left-quadrantanopsia-inferior) (right-parietal-lobe present))
	(<- (poorokn-direction lhoriz) (right-parietal-lobe present))
	(<- (nystagmus-type gazeev) (right-parietal-lobe present))
	(<- (abneom-type hgaze-left) (right-parietal-lobe present))
	(<- (facenumb-side left) (right-parietal-lobe present))
	(<- (swallow-severity partial) (right-parietal-lobe present))
	(<- (swallow-severity unable) (right-parietal-lobe present))
	(<- (gag-severity impaired) (right-parietal-lobe present))
	(<- (gag-severity absent) (right-parietal-lobe present))
	(<- (gait-type lhemi) (right-parietal-lobe present))
	(<- (gait-type other) (right-parietal-lobe present))
	(<- (dss-side left) (right-parietal-lobe present))
	(<- (pp-side left-mild) (right-parietal-lobe present))
	(<- (pp-side left-moderate) (right-parietal-lobe present))
	(<- (pp-side left-severe) (right-parietal-lobe present))
	(<- (posloss-side left) (right-parietal-lobe present))
	(<- (vibloss-side left) (right-parietal-lobe present))
	(<- (twopoint-side left) (right-parietal-lobe present))
	(<- (agraph-side left) (right-parietal-lobe present))

	; left parietal lobe
	
	(<- (decloc-degree drowsy) (left-parietal-lobe present))
	(<- (decloc-degree stupor) (left-parietal-lobe present))
	(<- (decloc-degree coma) (left-parietal-lobe present))
	(<- (disoriented-degree mild) (left-parietal-lobe present))
	(<- (disoriented-degree moderate) (left-parietal-lobe present))
	(<- (disoriented-degree severe) (left-parietal-lobe present))
	(<- (hemineglect-side right) (left-parietal-lobe present))
	(<- (compdef-severity mild) (left-parietal-lobe present))
	(<- (compdef-severity moderate) (left-parietal-lobe present))
	(<- (compdef-severity severe) (left-parietal-lobe present))
	(<- (repetition-severity mild) (left-parietal-lobe present))
	(<- (repetition-severity moderate) (left-parietal-lobe present))
	(<- (repetition-severity severe) (left-parietal-lobe present))
	(<- (nonfluency-severity mild) (left-parietal-lobe present))
	(<- (nonfluency-severity moderate) (left-parietal-lobe present))
	(<- (nonfluency-severity severe) (left-parietal-lobe present))
	(<- (anomia-severity mild) (left-parietal-lobe present))
	(<- (anomia-severity moderate) (left-parietal-lobe present))
	(<- (anomia-severity severe) (left-parietal-lobe present))
	(<- (cogabn present) (left-parietal-lobe present))
	(<- (vf-deficit-side-type right-hemianopsia) (left-parietal-lobe present))
	(<- (vf-deficit-side-type right-quadrantanopsia-inferior) (left-parietal-lobe present))
	(<- (dysarthria-severity mild) (left-parietal-lobe present))
	(<- (dysarthria-severity moderate) (left-parietal-lobe present))
	(<- (dysarthria-severity severe) (left-parietal-lobe present))
	(<- (poorokn-direction rhoriz) (left-parietal-lobe present))
	(<- (nystagmus-type gazeev) (left-parietal-lobe present))
	(<- (abneom-type hgaze-right) (left-parietal-lobe present))
	(<- (facenumb-side right) (left-parietal-lobe present))
	(<- (swallow-severity partial) (left-parietal-lobe present))
	(<- (swallow-severity unable) (left-parietal-lobe present))
	(<- (gag-severity impaired) (left-parietal-lobe present))
	(<- (gag-severity absent) (left-parietal-lobe present))
	(<- (gait-type rhemi) (left-parietal-lobe present))
	(<- (gait-type other) (left-parietal-lobe present))
	(<- (dss-side right) (left-parietal-lobe present))
	(<- (pp-side right-mild) (left-parietal-lobe present))
	(<- (pp-side right-moderate) (left-parietal-lobe present))
	(<- (pp-side right-severe) (left-parietal-lobe present))
	(<- (posloss-side right) (left-parietal-lobe present))
	(<- (vibloss-side right) (left-parietal-lobe present))
	(<- (twopoint-side right) (left-parietal-lobe present))
	(<- (agraph-side right) (left-parietal-lobe present))

	; right temporal lobe

	(<- (disoriented-degree mild) (right-temporal-lobe present))
	(<- (disoriented-degree moderate) (right-temporal-lobe present))
	(<- (disoriented-degree severe) (right-temporal-lobe present))
	(<- (decloc-degree drowsy) (right-temporal-lobe present))
	(<- (decloc-degree stupor) (right-temporal-lobe present))
	(<- (decloc-degree coma) (right-temporal-lobe present))
	(<- (cogabn present) (right-temporal-lobe present))
	(<- (hemineglect-side left) (right-temporal-lobe present))
	(<- (denial present) (right-temporal-lobe present))
	(<- (abneom-type hgaze-left) (right-temporal-lobe present))
	(<- (poorokn-direction lhoriz) (right-temporal-lobe present))
	(<- (swallow-severity partial) (right-temporal-lobe present))
	(<- (swallow-severity unable) (right-temporal-lobe present))
	(<- (gag-severity impaired) (right-temporal-lobe present))
	(<- (gag-severity absent) (right-temporal-lobe present))
	(<- (vf-deficit-side-type left-hemianopsia) (right-temporal-lobe present))
	(<- (vf-deficit-side-type left-quadrantanopsia-superior) (right-temporal-lobe present))

	; left temporal lobe

	(<- (disoriented-degree mild) (left-temporal-lobe present))
	(<- (disoriented-degree moderate) (left-temporal-lobe present))
	(<- (disoriented-degree severe) (left-temporal-lobe present))
	(<- (decloc-degree drowsy) (left-temporal-lobe present))
	(<- (decloc-degree stupor) (left-temporal-lobe present))
	(<- (decloc-degree coma) (left-temporal-lobe present))
	(<- (hemineglect-side right) (left-temporal-lobe present))
	(<- (compdef-severity mild) (left-temporal-lobe present))
	(<- (compdef-severity moderate) (left-temporal-lobe present))
	(<- (compdef-severity severe) (left-temporal-lobe present))
	(<- (repetition-severity mild) (left-temporal-lobe present))
	(<- (repetition-severity moderate) (left-temporal-lobe present))
	(<- (repetition-severity severe) (left-temporal-lobe present))
	(<- (anomia-severity mild) (left-temporal-lobe present))
	(<- (anomia-severity moderate) (left-temporal-lobe present))
	(<- (anomia-severity severe) (left-temporal-lobe present))
	(<- (nonfluency-severity mild) (left-temporal-lobe present))
	(<- (nonfluency-severity moderate) (left-temporal-lobe present))
	(<- (nonfluency-severity severe) (left-temporal-lobe present))
	(<- (cogabn present) (left-temporal-lobe present))
	(<- (abneom-type hgaze-right) (left-temporal-lobe present))
	(<- (poorokn-direction rhoriz) (left-temporal-lobe present))
	(<- (swallow-severity partial) (left-temporal-lobe present))
	(<- (swallow-severity unable) (left-temporal-lobe present))
	(<- (gag-severity impaired) (left-temporal-lobe present))
	(<- (gag-severity absent) (left-temporal-lobe present))
	(<- (vf-deficit-side-type right-hemianopsia) (left-temporal-lobe present))
	(<- (vf-deficit-side-type right-quadrantanopsia-superior) (left-temporal-lobe present))

	; right occipital lobe
	
	(<- (poorokn-direction lhoriz) (right-occipital-lobe present))
	(<- (vf-deficit-side-type left-hemianopsia) (right-occipital-lobe present))
	(<- (vf-deficit-side-type left-quadrantanopsia-superior) (right-occipital-lobe present))
	(<- (vf-deficit-side-type left-quadrantanopsia-inferior) (right-occipital-lobe present))

	; left occipital lobe
	
	(<- (poorokn-direction rhoriz) (left-occipital-lobe present))
	(<- (vf-deficit-side-type right-hemianopsia) (left-occipital-lobe present))
	(<- (vf-deficit-side-type right-quadrantanopsia-superior) (left-occipital-lobe present))
	(<- (vf-deficit-side-type right-quadrantanopsia-inferior) (left-occipital-lobe present))
	))

(setf *facts* nil)

(setf *nogoods* nil)
(setf *assumption-nogoods* nil)

(setf *inter-batch-beam-width* most-positive-fixnum)
(setf *intra-batch-beam-width* most-positive-fixnum)
(setf *bchain-depth* 2)
(setf *caching* t)
(setf *factoring* t)
(setf *remove-superset?* t)
(setf *remove-superset-fn* #'set-<=)
(setf *explanation-eval-metric* #'simplicity-only)

(setf *predicate-specific-abduction* t)
(setf *assumable-predicates*
      '(right-lateral-medulla left-lateral-medulla
	right-medial-medulla left-medial-medulla
	right-pons left-pons
	right-midbrain left-midbrain
	right-cerebellar-hemisphere left-cerebellar-hemisphere
	cerebellar-vermis
	right-thalamus left-thalamus
	right-basal-ganglia left-basal-ganglia
	right-internal-capsule left-internal-capsule
	right-frontal-lobe left-frontal-lobe
	right-parietal-lobe left-parietal-lobe
	right-temporal-lobe left-temporal-lobe
	right-occipital-lobe left-occipital-lobe))
(setf *free-assumption-predicates* nil)
