#+PCLS
(eval-when (compile load)
  (progn (setf (get 'lisp::mapcar 'psl::pass-1-macro) 'lisp::pa1m-mapcar)
	 (defmacro lisp::pa1m-mapcar (fcn list)
	   (psl::pass-1-map-collect list fcn t))))

;; This is for the lisp package.
#+PCLS
(eval-when (compile load)
  (in-package 'lisp)

  ;; This requires the compiler, but I dont know how to say that??

  ;; Define the return-from special form as a macro that just expands
  ;; into a call to a psl version.

  (defmacro return-from (name &optional value)
    `(psl::return-from ',name ,value))

  ;; Export the variable from the Lisp package.
  (export '(return-from))

  ;; Switch to the psl package.
  (in-package 'psl :use nil)

  ;; Make return-from a compiler function.
  (psl::put 'psl::return-from 'psl::compfn 'psl::&comp-return-from)

  ;; The compiler fun, checks that it is a legal return-from, and then
  ;; generates a move the result to the first register and exits.

  (psl::de psl::&comp-return-from (exp status&)
    (cond ((not (and (psl::pairp (cadr exp))
		     (eq (cadr (cadr exp)) psl::name&)))
	   (psl::error 999 "Return-from only allowed from function")))
    (psl::&comval (caddr exp) 1)
    (psl::&attach '(psl::*exit (psl::*framesize)))))
