% (C)1992 Institute for New Generation Computer Technology %
% $BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F$/$@$5$$(B
% (Read COPYRIGHT for detailed information.)

% 1992.7 Check and refine every program for IFS (ICOT Free
% Software) release.

use_package(fts).

macro_bank cil_macro_core has

% For cil.
    A / B => _ :- !,fail;

end.


class cil_builtin with_macro fts##cil_macro_core has

:append(_,X,Y,Z):-
    append(X,Y,Z);

:member(_,X,Y):-
    member(X,Y);

:locate(_,L,A,V):-
    locate(L,A,V);

:getRole(_,L,A,V):-
    getRole(L,A,V);

:partial(_,V):-
    unbound(V),!,fail;                  %this may cause a bug.
:partial(_,[(_/_)|_]):-!;

:fullCopy(_,X,Y):-
    fullCopy(X,Y);

:copy(_,X,Y):-
    copy(X,Y);

:merge(_,X,Y):-
    merge(X,Y);

:t_merge(_,X,Y):-
    t_merge(X,Y);

:delete(_,Label,X,Y):-
    delete(Label,X,Y);

:role(_,Label,X1,Value):-
    role(Label,X1,Value);

:setOfKeys(_,P,Set):-
    setOfKeys(P,Set);

:del_var(_,List) :-
    del_var(List);

local

append([],X,X) :- !;
append([X|Y],Z,[X|W]) :-
    append(Y,Z,W);

member(X,[X|_]) :- !;
member(X,[_|Y]) :-
    member(X,Y);

% ========== CIL PREDICATE ==========
locate(_,[],_) :- !,fail;
locate([P|_],A,V):-
    bound(P),
    [P] = [A/V];
locate([_|R],A,V):-
    bound(R),
    locate(R,A,V);

getRole([A/V|_],A,V):-
    bound(A);
getRole([_|R],A,V):-
    bound(R),
    getRole(R,A,V);

fullCopy(XT,_):-
    unbound(XT),!;
fullCopy([X],[_]):-
    unbound(X),!;
fullCopy([],[]):- !;
fullCopy([L/XV|XR],[L/YV|YR]):- !,
    fullCopy(XV,YV),
    fullCopy(XR,YR);
fullCopy([XE|XR],[XE|YR]):- !,
    fullCopy(XR,YR);
fullCopy(X,X) :- !;

copy([],[]):- !;
copy([XE|XR],[XE|YR]):-
    copy(XR,YR);

merge([],_):- !;
merge([L/V|XR],Y):-
    role(L,Y,V),
    merge(XR,Y);

t_merge([],_):- !;
t_merge([L/V|XR],Y):-
    ( unbound(V),!,
      role(L,Y,_)
    ; partial(V),!,
      role(L,Y,YV),
      t_merge(V,YV),
      t_merge(XR,Y)
    ; role(L,Y,V),
      t_merge(XR,Y) );

delete(_,[],_):- !;
delete(L,[L/V|XR],Y):-
    copy(XR,Y);
delete(L,[XE|XR],[XE|YR]):-
    delete(L,XR,YR);

role(L,X,V):-
    unbound(X),!,
    X = [L/V|_];
role(L,[L/V1|_],V):-
    !,V1 = V;
role(L,[_|R],V):-
    role(L,R,V);

setOfKeys([],[]):-!;
setOfKeys([L/_|XR],[L|LR]):-
    setOfKeys(XR,LR);

partial(V):-
    unbound(V),!,fail;                  %this may cause a bug.
partial([(_/_)|_]):-!;

del_var(X) :-
    ( unbound(X), !,
      X = []
    ; X == [] ), !;
del_var([_|T]):-
    del_var(T);

% ========= ESP PREDICATE ==========
%atom_to_string(Atom,String) :-
%    atom_string(Atom,String);

end.


macro_bank cil_macro has

nature cil_macro_core;

print(X) =>
    :putt(standard#output,X);
write(X) =>
    :putt(standard#output,X);
append(X,Y,Z) =>
    :append(#fts##cil_builtin,X,Y,Z);
member(X,Y) =>
    :member(#fts##cil_builtin,X,Y);
locate(L,A,V) =>
    :locate(#fts##cil_builtin,L,A,V);
getRole(L,A,V) =>
    :getRole(#fts##cil_builtin,L,A,V);
partial(X) =>
    :partial(#fts##cil_builtin,X);
fullCopy(X,Y) =>
    :fullCopy(#fts##cil_builtin,X,Y);
copy(X,Y) =>
    :copy(#fts##cil_builtin(X,Y));    
merge(X,Y) =>
    :merge(#fts##cil_builtin,X,Y);
t_merge(X,Y) =>
    :t_merge(#fts##cil_builtin,X,Y);
delete(L,X,Y) =>
    :delete(#fts##cil_builtin,L,X,Y);
role(Label,X1,Value) =>
    :role(#fts##cil_builtin,Label,X1,Value);
setOfKeys(P,Set) =>
    :setOfKeys(#fts##cil_builtin,P,Set);
nl =>
    :putf(standard#output,"\n");
get(X) =>
    :getc(standard#input,X);

del_var(List) =>
    :del_var(#fts##cil_builtin,List);

end.
                                           