// terminal.hpp
// Terminal Set Class definitions  --> defined in funcset.cpp

#ifndef __TERMINAL

#define __TERMINAL

#include <stdarg.h>
#include <stdlib.h>     // for rand
#include <iostream.h>


class Terminal
{
	int iTerminal;
	Terminal *ptNext;
	friend class TS;               // TS needs to access private bits, honest!
	friend ostream& operator << ( ostream&, Terminal* );
	friend ostream& operator << ( ostream&, TS*  );
	friend int terminal( Terminal *pt ) { return pt->iTerminal; };
public:
	Terminal();
};

class TS
{
	Terminal *ptHeader;						 // header to Terminal Set
	friend ostream& operator << ( ostream&, TS* );
public:
	TS();
	TS( int noofargs, ... );			 // Terminal values then arguments
	~TS();
	int Length();
	Terminal *Nth( int n );
	Terminal *Choose();
};

extern TS *TerminalSet;

extern void ExitSystem( char* );

#endif
