// terminal.cpp

// By Adam Fraser 7/06/93

// Terminal Set system using C++ and all the ease of OOP programming
// 	 for use in the Genetic Program system

/* Genetic Programming System using the C++ programming language

 Input is of the form gp <pop> <gen> <output file>

 A Potted History:

	 Version 1.00 BETA (sometime March 1993). Very Buggy,...
	 Version 2.00 C++ version very easy language 16 July 1993
								ERRORS in load and saving a genetic program.
											 No capacity for extended memory in DOS.
											 No differing creation mechanism.
											 No touranment selection
											 No capacity for encapsulation
	 Version 3.00 C++ Version.( Uncompatible with previous versions )
											 Robust with full use of OOP techniques.
											 Compatibility with ANSI standard.
											 Ramped half and half implemented.
											 Tournament selection implemented.
											 Changing variables does not require recompiling.
											 BUT STILL
											 No capacity for expanded or extended memory in DOS.
											 No capacity for encapsulation.

	 C version in progress
	 Windows version in progress but its all gobblydegook.


	 Version 3.00 can be compiled in the DOS and UNIX domain
	 but NOT in Windows. This was not made clear in previous programs.

 Genetic programming in C++ was designed and choreographed by Adam P.Fraser

		Food parcels, cash and trashy sci-fi novels to:

					 a.fraser@eee.salford.ac.uk
					snail:
					 A.Fraser
					 PostGraduate Section,
					 Maxwell Building,
					 Elec & Elec Eng,
					 University Of Salford,
					 Salford,
					 M5 4WT.
					 England


		Your comments, improvements and complaints are welcome.


 This code is intended as a base for C++ GPers. Please if you adapt the code
 send me a msg. Also could you please keeps these comments and my address in
 the code.

							regards,
											Adam Fraser ;-)
											16 November 1993

	' and one day there shall come an artificial ant who can complete the santa
	fe trail in 400 evaluation steps and on that day there shall be oink flap'
*/

#include "terminal.hpp"

// #define TEST

// Print terminals... using ostream

ostream& operator << ( ostream& os, Terminal *pt )
{
	os << "Terminal: " << pt->iTerminal << endl;
	return os;
}

ostream& operator << ( ostream& os, TS *pts )
{
	if ( pts )
	{
		Terminal *pt = pts->ptHeader;

		while (	pt ) { os << pt; pt = pt->ptNext;	}
	}
	return os;
}


Terminal::Terminal()
{
	iTerminal = 0;
	ptNext = NULL;
}

TS::TS()
{
	ptHeader = NULL;
}

TS::TS( int noofargs, ... )
{
	va_list ap;                               // ap =  variable list
	Terminal *pt;

	va_start( ap, noofargs );	                // necessary for variable list

	if ( noofargs == 0 ) return;			        // why would anyone do this

	if ( !(ptHeader = new Terminal) ) ExitSystem( "TS::TS" );

	ptHeader->iTerminal = va_arg( ap, int );  // read off a value

	pt = ptHeader;                            // reset to start for args

	for ( int i = 1; i < noofargs; i++)
	{
		if ( !(pt->ptNext = new Terminal) ) ExitSystem( "TS::TS" );
		pt = pt->ptNext;
		pt->iTerminal = va_arg( ap, int );      // read next value
	}

	va_end( ap );                             // necessary for variable list
}


TS::~TS()
{
	if ( this )
	{
		Terminal *pt = ptHeader, *ptOld = ptHeader;

		while ( pt )
		{
			pt = ptOld->ptNext;
			delete ptOld;
			ptOld = pt;
		}
	}
}

int TS::Length()
{
	int count = 0;
	Terminal *pt = ptHeader;

	while ( pt ) { pt = pt->ptNext;	count++; }

	return count;
}

// Up to the programmer to make sure n is below total length of terminal set

Terminal* TS::Nth( int n )
{
	Terminal *pt= ptHeader;

	for ( int i = 1; i < n; i++ ) pt = pt->ptNext;

	return pt;
}

// This terminal would probably have been better written with loads of temp
//  variables my software eng lecturer of yesteryear would not be happy...
// Basically this chooses a value from the Terminal set... APF 7/03/93

Terminal* TS::Choose()
{
	return ( Nth( ( rand() %  Length() ) + 1 ) );
}

#ifdef TEST

// test main() code for terminals in this section

main(void)
{
	TS *TerminalSet = new TS( 4, 1,2,3,4 );

	cout << TerminalSet;

	cout << TerminalSet->Length() << endl;

	cout << terminal( TerminalSet->Nth(3) ) << endl;

	cout << terminal( TerminalSet->Choose() ) << endl;

	return 0;
}

#endif

// terminal.cpp


