// gpsetup.cpp

// a small program to create gp.ini with selected parameters....
#include "gpv.hpp"

main()
{
  unsigned int uiInput;
  GPVariables gpv( 0, 0 );
	unsigned int bFound = 1;

	while ( bFound )
	{
		cout << endl << "Please choose a type of creation." << endl << endl;

		cout << "1...Variable" << endl;
		cout << "2...Grow" << endl;
		cout << "3...Ramped half and half" << endl;
		cout << "4...Ramped Variable" << endl;
		cout << "5...Ramped Grow" << endl << endl;

		cout << "Value from 1-5, Please...";

		do { cin >> uiInput; } while ( ( uiInput <= 0 ) && ( uiInput > 6 ) );

		gpv.CreationType = --uiInput;   // have to -1 to bring in line with gpsys

		cout << endl << "The Number Of Evaluations ? ";

		do { cin >> uiInput; } while ( uiInput <= 0 );

		gpv.NumberOfEvaluations = uiInput;

		cout << endl << "Maximum Fitness ? ";

		do { cin >> uiInput; } while ( uiInput <= 0 );

		gpv.MaximumFitness = uiInput;

		cout << endl << "Maximum Depth For Creation ? ";

		do { cin >> uiInput; } while ( uiInput <= 0 );

		gpv.MaximumDepthForCreation = uiInput;

		cout << endl << "Maximum Depth For Crossover ? ";

		do { cin >> uiInput; } while ( uiInput <= 0 );

		gpv.MaximumDepthForCrossover = uiInput;

		cout << endl << endl;
		cout << "Creation Type              : ";
		switch( gpv.CreationType )
		{
			case VARIABLE :
				cout << "Variable";
				break;
			case GROW :
				cout << "Grow";
				break;
			case RAMPEDHALF :
				cout << "Ramped Half and Half";
				break;
			case RAMPEDVARIABLE :
				cout << "Ramped Variable";
				break;
			case RAMPEDGROW :
				cout << "Ramped Grow";
				break;
			default       :
				cout << "Error...";
		}
		cout << endl;
		cout << "Number Of Evaluations      : " << gpv.NumberOfEvaluations << endl;
		cout << "Maximum Fitness            : " << gpv.MaximumFitness << endl;
		cout << "Maximum Depth For Creation : " << gpv.MaximumDepthForCreation << endl;
		cout << "Maximum Depth For Crossover: " << gpv.MaximumDepthForCrossover << endl;

		cout << endl << "Is this Correct (y/n)";

		char ch;
		cin >> ch;
		if ( (ch == 'Y') || (ch == 'y') ) bFound = 0;
	}

	ofstream ofs( "gp.ini" );
	gpv.Save( ofs );
	ofs.close();

	cout << "Saved setup to file gp.ini" << endl;

	cout << endl << "GPSetup: An Evolutionary Solution by Adam P.Fraser" << endl;

	return 0;
}