// gpmain.cpp
// By Adam Fraser  16/11/93


/* Genetic Programming System using the C++ programming language

 Input is of the form gp <pop> <gen> <output file>

 A Potted History:

	 Version 1.00 BETA (sometime March 1993). Very Buggy,...
	 Version 2.00 C++ version very easy language 16 July 1993
								ERRORS in load and saving a genetic program.
											 No capacity for extended memory in DOS.
											 No differing creation mechanism.
											 No touranment selection
											 No capacity for encapsulation
	 Version 3.00 C++ Version.( Uncompatible with previous versions )
											 Robust with full use of OOP techniques.
											 Compatibility with ANSI standard.
											 Ramped half and half implemented.
											 Tournament selection implemented.
											 Changing variables does not require recompiling.
											 BUT STILL
											 No capacity for expanded or extended memory in DOS.
											 No capacity for encapsulation.

	 C version in progress
	 Windows version in progress but its all gobblydegook.


	 Version 3.00 can be compiled in the DOS and UNIX domain
	 but NOT in Windows. This was not made clear in previous programs.

 Genetic programming in C++ was designed and choreographed by Adam P.Fraser

		Food parcels, cash and trashy sci-fi novels to:

					 a.fraser@eee.salford.ac.uk
					snail:
					 A.Fraser
					 PostGraduate Section,
					 Maxwell Building,
					 Elec & Elec Eng,
					 University Of Salford,
					 Salford,
					 M5 4WT.
					 England


		Your comments, improvements and complaints are welcome.


 This code is intended as a base for C++ GPers. Please if you adapt the code
 send me a msg. Also could you please keeps these comments and my address in
 the code.

							regards,
											Adam Fraser ;-)
											16 November 1993

	' and one day there shall come an artificial ant who can complete the santa
	fe trail in 400 evaluation steps and on that day there shall be oink flap'
*/

#include "gpmain.hpp"
#include "function.hpp"
#include "terminal.hpp"

#include <string.h>
#include <math.h>

FS *FunctionSet;
TS *TerminalSet;

extern void RunGPS( int, int, char* );

void MemoryLeft( void );
void ErrorPrint( void );
int str2int( char* );


/* here we go the main bit of code */

main( int argv, char **argc )
{
	if ( (argv <= 1) || ( argv > 4 ) )  /* error checking is very simplistic */
	{
		ErrorPrint();
		ExitSystem( "" );
	}
	else RunGPS( str2int( argc[1] ), str2int( argc[2] ), argc[3] );

  return 0;
}


void ErrorPrint( void )
{
 cout << endl;
 cout << "Format is:  gp <PopulationSize> <Number of Generations> <Output File>";
 cout << endl << "Example: gp 500 51" << endl;;
}


int str2int( char *str )
{
	int i, sum = 0, len = strlen( str );

	for ( i = len; i > 0; i-- )	sum += ( *str++ - '0') * pow( 10 , i-1 );

	return sum;
}

/* gpmain.c */