function trukdemo
% BACKING UP A TRUCK demonstration with Fuzzy Control
%
% This file controls the usage of either Controller 1 or 2 on the 
% backing up of a truck.

% Copyright (c) 1993 by PWS Publishing Company

clc
disp('The challenge here is to back a truck without a trailer to a particular');
disp('spot on a loading dock at the top of the screen.  Also, we would like the');
disp('truck to approach the dock with its body perpendicular to the dock.  The');
disp('first set of four pictures show the motion of an uncontrolled truck.');
disp('');
disp('Hit any key to view Uncontrolled Truck...');
pause

% Uncontrolled Truck Simulation
truksim;

% Controlled Truck Simulation
trk_title = 'View Controller 1 or 2 in Action...?';
opt1 = 'Controller 1';
opt2 = 'Controller 2';
opt3 = 'Exit Truck Demo';

clc
disp('The truck can have a horizontal position ranging from 0 to 100.  This range');
disp('is covered here with five fuzzy sets.  Ranges for the truck angle and ');
disp('steering angle are divided into seven sets each.  Controller 1 backs the truck');
disp('successfully, but the truck is not well centered at the dock.');
disp('');
disp('To improve performance, we design controller 2 with the middle three');
disp('horizontal fuzzy sets gathered in the center of the horizontal position.');
disp('Now the truck turns toward the center more quickly, centers well, and');
disp('approaches the dock at a 90 degree angle as desired.');
disp('');

sel = menu(trk_title, opt1, opt2, opt3);

while sel ~= 3,

 if sel == 1,
  trukcon1;
 elseif sel == 2,
  trukcon2;
 end
 
 clc 
 sel = menu(trk_title, opt1, opt2, opt3);
 
end

