% TRKDEMO Simulation of uncontrolled truck.

% Mark Beale 6-24-93
% Copyright (c) 1993 by PWS Publishing Company

% setup beginning of demo
demostrt

set(info_win,'name','Truck Backer');
set(b(2),'callback','trkdemob');               
     
% TRUCK WINDOW
f1 = figure('name','Uncontrolled Truck','numbertitle','off',...
            'units','norm','pos',[20,20,600,430]./scrn,'menubar','none',...
            'vis','off');
plot(50,0,'*');
grid;
set(gca,'xlim',[0 100],'ylim',[-100 0]);

% HORIZONTAL POSITION RESPONSE WINDOW            
f2 = figure('name','Horizontal Position Response','numbertitle','off',...
            'units','norm','pos',[10,250,305,205]./scrn,'menubar','none',...
            'vis','off');

% VERTICAL POSITION RESPONSE WINDOW            
f3 = figure('name','Vertical Position Response','numbertitle','off',...
            'units','norm','pos',[10,10,305,205]./scrn,'menubar','none',...
            'vis','off');
            
% TRUCK ANGLE RESPONSE WINDOW            
f4 = figure('name','Truck Angle Response','numbertitle','off',...
            'units','norm','pos',[325,10,305,205]./scrn,'menubar','none',...
            'vis','off');

% STEERING ANGLE RESPONSE WINDOW            
f5 = figure('numbertitle','off','units','norm','pos',[325,250,305,205]./scrn,...
            'menubar','none','vis','off');

windows=[info_win,f1,f2,f3,f4,f5];

str=['The challenge here is to back a truck without a trailer to a particular spot on a ',...
'loading dock at the top of the screen.  Also, we would like the truck to approach ',...
'the dock with its body perpendicular to the dock.  The first set of four pictures ',...
'show the motion of an uncontrolled truck.'];

han=strformt(str,[80,480],info_win);
set(info_str(1),'string','Refer to Chapter 5 of the User''s Guide');
set(info_str(2),'string','Also, refer to the script TRUKSIM');
set(info_win,'vis','on');
