function g = triangle(s,v)
% TRIANGLE Evaluates triangular shaped fuzzy sets.
%
% TRIANGLE(S,[A1,B1,C1; A2; B2; C2; ...; An,Bn,Cn])
%   S  - Support (row) vector.
%   Ai - Left side for ith triangle.
%   Bi - Peak for ith triangle.
%   Ci - Right side for ith triangle.
% Returns matrix of n triangular shaped grade vectors
%   defined over support vector S.
%
% EXAMPLE: s = 0:.1:10;
%          g = triangle(s,[3 5 7; 6 8 10]);
%          plotfs(s,'Two Triangular Fuzzy Sets')
%          plot(s,g)
%          hold off
%
% SEE ALSO: Bell, Bump, Flatbump, Rectangl, Rectangl, Single, Trapzoid

% Mark Beale 6-24-93
% Copyright (c) 1993 by PWS Publishing Company

[vr,vc] = size(v);
sl = length(s);
g = zeros(vr,sl);

for i=1:vr
  a = v(i,1);
  b = v(i,2);
  c = v(i,3);

  up_ind = find(s >= a & s < b);
  pk_ind = find(s == b);
  dn_ind = find(s > b & s <= c);

  if length(up_ind), g(i,up_ind) = (s(up_ind)-a)*(1/(b-a)); end
  if length(pk_ind), g(i,pk_ind) = 1; end
  if length(dn_ind), g(i,dn_ind) = (s(dn_ind)-c)*(1/(b-c)); end
end
