function g=single(s,n)
% SINGLE Creates singleton shaped fuzzy sets.
%
% SINGLE(S,[A1; A2; ...; An])
%   S  - Support (row) vector.
%   Ai - Position of ith singleton.
% Returns matrix of n singleton shaped grade vectors
%   defined over support vector S.
%
% EXAMPLE: s = 0:10;
%          g = single(s,3)
%          plotfs(s,'Crisp set of 3')
%          plot(s,g,'*')
%          hold off
%
% SEE ALSO: Bell, Bump, Rectangl, Trapzoid, Triangle

% Mark Beale 6-24-93
% Copyright (c) 1993 by PWS Publishing Company

[row_n,col_n] = size(n);
[row_s,col_s] = size(s);

g = abs(ones(row_n,1)*s - n*ones(1,col_s)) <= eps;
