% PENDSIM Simulation of uncontrolled pendulum.
%   This script is referred to in Chapter 5.
%
% USES: pendmod, pendplot

% Mark Beale 6-24-93
% Copyright (c) 1993 by PWS Publishing Company

clc
clear

% SIMULATION OF UNCONTROLLED PENDULUM
% ===================================

disp('We would like to move a cart so that it balances an inverse pendulum');
disp('and completes the balancing at ''0'' on the horizontal scale.  The first');
disp('screen shows an uncontrolled pendulum simply falling onto the cart.');
disp('');
disp('Hit any key to view Uncontrolled Pendulum...');
pause

% INITIAL STATE
deg = pi/180;
x0 = [0; 0; 1*deg; 0*deg];

% Cart position = 0 meters
% Cart velocity = 0 meters/sec
% Pendulum angle = 1 degree
% Pendulum velocity = 0 degrees

% TIME
t0 = 0;
t1 = 5;
dt= 0.05;
T = (t0+dt):dt:t1;
steps = length(T);

% FORCE
u = 0;

X = zeros(4,steps);

x = x0;
pendplot(x,u,0);
for i=1:steps

  % UPDATE STATE
  x = x + dt * pendmod(x,u);
  
  % CHECK FOR COLLISION OF PENDULUM WITH BASE
  if abs(x(3)) > pi/2, x(3) = sign(x(3))*pi/2; end

  % PLOT EVERY 8 TIMESTEPS
	 if rem(i,4) <= eps
	 pendplot(x,u,i*dt);
	 end

  % SAVE VALUES
	 X(:,i) = x;
end

% PLOT RESPONSES
% ==============

% POSITION RESPONSE
clc
disp('Hit any key to see the Position Response...')
pause
plot([t0 T],[x0(1) X(1,:)])
hold on
plot([t0 t1],[0 0],':')
hold off
title('Position Response')
xlabel('Time (Seconds)')
ylabel('Position (Meters)')
pause

% ANGULAR RESPONSE
clc
disp('Hit any key to see the Angular Response...')
pause
plot([t0 T],[x0(3) X(3,:)]/deg)
hold on
plot([t0 t1],[0 0],':')
hold off
title('Angular Response')
xlabel('Time (Seconds)')
ylabel('Angle (Degrees)')
pause

clc
disp('The pendulum system has two controllers: 1) The balancing controller, with');
disp('pendulum angle error and pendulum position as inputs, produces the force');
disp('required to move the pendulum angle to zero; and 2) The angle controller');
disp('with the cart''s position and velocity as inputs produces a desired');
disp('''reference'' angle for the pendulum.  Six fuzzy sets are required for');
disp('these two systems.');
disp('');
disp('Hit any key to view Controlled Pendulum...');
pause
pendcon
