% Stage 3 for Pendulum Demonstration

% Copyright (c) 1993 by PWS Publishing Company

% DEFINITION OF VARIABLE RANGES
% =============================
set(info_win,'vis','off');
set(info_str,'string','');
delete(han);

deg = pi/180; % (a degree in radians)

% FUZZY SETS
% ==========

% POSITION
PosL = eqshape(3,[-75 75],5,'extend');

% VELOCITY
VelL = eqshape(3,[-20 20],5,'extend');

% ANGLE
AngleL = eqshape(3,[-90, 90]*deg,7,'extend');

% ANGULAR VELOCITY
AngleVelL = eqshape(3,[-4 4],7,'extend');

% REFERENCE ANGLE
RefS = [-55:(55/2):55]*deg;

% CONTROL FORCE
ForceS = -400:(400/3):400;

% PLOT FUZZY SETS
% ===============
set([f1,f2,f3],'vis','off');

delete(get(f2,'chil'));
delete(get(f3,'chil'));

set(f2,'name','Fuzzy Sets for Position',...
       'pos',[14,214,315,230]./scrn);
set(f3,'name','Fuzzy Sets for Base Velocity',...
       'pos',[63,175,315,230]./scrn);
set(f4,'name','Fuzzy Sets for Angle');
set(f5,'name','Fuzzy Sets for Angular Velocity');
set(f6,'name','Fuzzy Sets for Reference Angle');
set(f7,'name','Fuzzy Sets for Control Force');

figure(f2);
PosS = -75:(75/24):75;
PosG = shapeval(PosL,PosS);
plotfs2(PosS,'Fuzzy Sets for Position', 'Position (meters)');
plot(PosS,PosG);

figure(f3);
VelS = -20:(20/24):20;
VelG = shapeval(VelL,VelS);
plotfs2(VelS,'Fuzzy Sets for Velocity', 'Velocity (meters/second)');
plot(VelS,VelG);

figure(f4);
AngleS = (-pi/2):(pi/48):(pi/2);
AngleG = shapeval(AngleL,AngleS);
plotfs2(AngleS/deg,'Fuzzy Sets for Angle','Angle (Degrees)');
plot(AngleS/deg,AngleG);

figure(f5);
AngleVelS = -4:4/24:4;
AngleVelG = shapeval(AngleVelL,AngleVelS);
plotfs2(AngleVelS,'Fuzzy Sets for Angular Velocity', ...
  'Angular Velocity (Rad/sec)');
plot(AngleVelS,AngleVelG);

figure(f6);
RefG = ones(size(RefS));
plotfs2(RefS*deg,'Fuzzy Sets for Reference Angle','Ref Angle (Deg)');
plot(RefS*deg,RefG,'*');

figure(f7);
ForceG = ones(size(ForceS));
plotfs2(ForceS,'Fuzzy Sets for Control Force','Force (Kg*m/sec^2)');
plot(ForceS,ForceG,'*');

drawnow;

% DEFINITION OF CONTROLLER 1
% ==========================
% Decides reference angle based on position and velocity:
  
% ANTECEDANT TABLE
A1 = table(1:5,1:5);

% WEIGHT TABLE, Rows represent Velocity, Columns represent Position

W1 = [1.0;  1.0;  1.0;  0.5;  0.0;
      1.0;  1.0;  0.5;  0.0; -0.5;
      1.0;  0.5;  0.0; -0.5; -1.0;
      0.5;  0.0; -0.5; -1.0; -1.0;
      0.0; -0.5; -1.0; -1.0; -1.0];

% GROUP OF FUZZY SETS
Z1 = group(PosL,VelL);

% DEFINITION OF CONTROLLER 1
% ==========================
% Determines Force based on Angle and Angular velocity:

% ANTECEDANT TABLE
A2 = table(1:7,1:7);

% WEIGHT TABLE, Rows represent Angle, Cols represent Angular Velocity
W2 = [-400; -400; -400; -400; -266; -133;   0;
      -400; -400; -400; -266; -133;    0; 133;
      -400; -400; -266; -266;    0;  133; 266;
      -400; -266; -133;    0;  133;  266; 400;
      -266; -133;    0;  266;  266;  400; 400;
      -133;    0;  133;  266;  400;  400; 400;
         0;  133;  266;  400;  400;  400; 400];

% GROUP OF FUZZY SETS
Z2 = group(AngleVelL,AngleL);

left=(scrnsz(3)-300)/2;
botm=(scrnsz(4)-80)/2;
set(info_win,'pos',[left,botm,300,80]);
set(info_str(1),'string','View Pendulum Controller in action...?',...
                'pos',[20,55,260,20]);
set(info_str(2),'pos',[20,30,260,20]);
set(b(1),'pos',[7,5,90,20]);
set(b(2),'vis','off','pos',[105,5,87,20]);
set(b(3),'string','Controller','callback','pendemoe','pos',[203,5,90,20]);
set(info_win,'vis','on');



