% Stage 2 for Pendulum Demonstration

% Copyright (c) 1993 by PWS Publishing Company

% PLOT RESPONSES
% ==============

set([f1,info_win],'vis','off');
set(info_str,'string','');

set(f2,'name','Position Response','pos',[20,240,600,190]./scrn);
set(f3,'name','Angular Response','pos',[20,20,600,190]./scrn);

% POSITION RESPONSE
figure(f2);
plot([t0 T],[x0(1) X(1,:)])
xlabel('Time (Seconds)')
ylabel('Position (Meters)')
grid

% ANGULAR RESPONSE
figure(f3);
plot([t0 T],[x0(3) X(3,:)]/deg)
xlabel('Time (Seconds)')
ylabel('Angle (Degrees)')
grid

left=(scrnsz(3)-480)/2;
botm=(scrnsz(4)-80)/2;
set(info_win,'pos',[left,botm,480,80]);
set(b(1),'pos',[73,5,90,20]);
set(b(2),'vis','off','pos',[196,5,90,20]);
set(b(3),'string','Fuzzy Sets','callback','pendemod','vis','on',...
         'pos',[319,5,90,20]);

str=['The pendulum system has two controllers: 1) The balancing controller, with ',...
'pendulum angle error and pendulum position as inputs, produces the force ',...
'required to move the pendulum angle to zero; and 2) The angle controller with ',...
'the cart''s position and velocity as inputs produces a desired ''reference'' angle for ',...
'the pendulum.  Six fuzzy sets are required for these two systems.'];

han=strformt(str,[80,480],info_win);
set(info_str(1),'string','Fuzzy Sets for Pendulum Controllers',...
                'pos',[110,55,260,20]);
set(info_str(2),'pos',[110,30,260,20]);               
set(info_win,'vis','on');
