% Stage 5 for Number Recognition Demonstration

% Copyright (c) 1993 by PWS Publishing Company

set(info_win,'vis','off');
set(info_str,'string','');

set(f1,'vis','off');

% FUZZY PREPROCESSING
% ===================

XG = fuzzyval(xS,xG,x);
YG = fuzzyval(yS,yG,y);

G = allcomb('min',XG,YG);
G = or(G')';

% grades_5x7_grid = (reshape(G,5,7)');

% CALCULATE EACH PATTERNS GRADE
% =============================

G0 = and([ or( G([2 7]));  or( G([3 8]));  or( G([4 9]));
           or( G([11 12]));  or( G([16 17]));  or( G([21 22]));
           or( G([14 15]));  or( G([19 20]));  or( G([24 25]));
           or( G([27 32]));  or( G([28 33]));  or( G([29 34]));
           not( G([13 18 23]) ) ]);
G1 = or([ and([ G([5 9 18 27 31]);
                not(G([1 2 3 6 7 11 25 29 30 33 34 35])) ]);
          and([ G([1 7 18 29 35]);
                not(G([3 4 5 9 10 15 21 26 27 31 32 33])) ]);
          and([ G([1 6 11 16 21 26 31]);
                not(G([3 4 5 8 10 13 15 18 20 23 25  ...
                       28 30 33 34 35])) ]);
          and([ G([2 3 4 5]);
                not(G([6 7 10 11 12 15 16 17 20 25 30 35]));
		or( G([8 9]));
                or( G([13 14]));
                or( G([18 19]));
                or( G([23 24]));
                or( G([28 29]));
                or( G([33 34]));  ]) ]);
G2 = and([ somewhat(G(2));
           G([3 32 33 34]);
           or( G([6 7]));  or( G([30 25]));  or( G([4 5]));
           not([ G([22 28]); and(G([10 15])) ]) ]);
G3 = and([ G([2 3 19 32 33 34]);
           or( G([9 10]) );
           or( G([14 15]) );
           not( G([5 16 21]) ) ]);
G4 = and([ or([ and(G([4 14 19 29])); and(G([5 15 20 30])) 
             and(G([3 13 18 28])) ]);
           or([and(G([12 14 15])); and(G([17 19 20]));
             and(G([22 24]))  ]);
           not([ G([1 2 6 7]); and(G([32 33 34])) ]) ]);
G5 = and([ G([3 18 32 33 34]);
           or( G([26 27]) );
           or( G([21 22]) );
           or( G([14 15]) );
           or( G([9 10]) );
           not( very( and(G([11 16])) ) );
           not(and(G([25 30])) ) ]);
G6 = and([ G([3 6 10 11 16 33]);
           not([ G([25 31]); and(G([8 13])) ]); ]);
G7 = and([ or( G([32 27]));
           or( G([33 28]));
           or( G([34 29]));
           or( G([35 30]));
           very(not([ and(G([2 4])); and(G([7 9])); and(G([13 15])) ]));
           or( G([1 2 3 4 5]) );
           very(not(G([11 16 21 22])));
           not( very(G(17))) ]);
G8 = and([ G([3 33 18])
           or( G([29 30]));
           or( G([24 25])); 
           or( G([6 7]));
           or( G([11 12]));
           or( G([9 10]));
           or( G([14 15]));
           or( G([21 22]));
           or( G([26 27])); ]);
G9 = and([ G([21 25 26 30 33]);
           not( and(G([6 11]))) ]);

% COMBINE INTO FUZZY SET
% ======================

cS = 0:9;
cG = [G0 G1 G2 G3 G4 G5 G6 G7 G8 G9];

% FIND SUPPORTS WITH MAXIMUM GRADE
% ================================

% FIND DIGITS WITH MAXIMUM GRADES
c = cS(find(cG >= max(cG)));

% DISPLAY RESULTS
% ===============

clc
fprintf('CHARACTER GRADES:\n\n')
for i=1:10
  fprintf('The grade for "%g" is: %g\n',cS(i),cG(i));
end
%fprintf('\nCHARACTER RECOGNITION RESULTS:\n\n');
T1 = sprintf('The digit is a: %g',c(1));
for i=2:length(c)
  T2 = sprintf(' or %g',c(i));
  T1 = [T1 T2];
end

left=scrnsz(3)-320;
botm=(scrnsz(4)-80)/2;
set(info_win,'pos',[left,botm,300,80]);
set(info_str(1),'string',T1);
set(info_str(2),'string','Create another Number...?');
set(b(2),'vis','off');
set(b(3),'string','Number','callback',...
         'set(f1,''pointer'',''crosshair'');clc;numdemoc','vis','on');
set(info_win,'vis','on');


