//:ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: SDLProcess.h,v 0.22 1994/07/22 09:21:42 cncl-adm Exp cncl-adm $
 *
 * Class: CNSDLProcess --- ...
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __CNSDLProcess_h
#define __CNSDLProcess_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Object.h>		// Base class
#include <CNCL/SDLManager.h>  // Communication Manager (SDL functions)

extern CNClassDesc CN_SDLPROCESS;	// Class CNSDLProcess description



class CNSDLProcess;
typedef int(CNSDLProcess::*PMF)(int); 


int(CNSDLProcess::*_global_pointer_to_actual_sdlsignalhandler_)(int);
        // sorry, I have to use a global identifier. procedures didn't
        // work without it (olly)


/*
 * The class CNSDLProcess
 */

class CNSDLProcess : public CNObject
{
  friend class CNSDLManager;      // Communication-Manager etc.
  friend class CNSDLEnvironment;  // needs access to 'System'

  protected:
    int state();     // get/set process state
    void state(int);
    
    int type();      // get process type
    
    char *get_name() const;
    
    CNSimTime now();
    
    void procedure(PMF); // procedure-call
                         // (contains address of new sdl handler)
    void return_from_procedure();    // self explaining

    virtual int process(int);     // process body
        
    // Private members
  private:
    
    int actual_state;
    int hc_fpc;
    
    int p_type;  // process type
    
    struct stack_i { int old_state;    // stack used for procedure calls  
                     PMF old_handler;
                     int helpval;
                     stack_i *stack_end;
                   } *stack;
    
    char *name;
    
    PMF handler;   //  local pointer to signal handler
                   // (process, procedure)

    int signalhandler(int);  // is called from SDLManager

  protected:
    CNSDLManager *System;   // pointer to system's SDLManager
    
    /***** Constructors ******************************************************/
  public:
    CNSDLProcess() {}				// Default constructor
    CNSDLProcess(CNParam *param) {}			// CNParam constructor
    
    CNSDLProcess(char*, CNSDLManager*, int);
    
    /***** Member functions required by CNCL *********************************/
  public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_SDLPROCESS;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_SDLPROCESS ? TRUE : CNObject::is_a(desc);
    };
        
    static CNSDLProcess *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
        return (CNSDLProcess *)obj;
#   else
        return (CNSDLProcess *)( !obj || obj->is_a(CN_SDLPROCESS)
               ? obj : fatal_type(obj->class_desc(), CN_SDLPROCESS) );
#   endif
    }
    
    
    // CNObject creation
    static CNObject *new_object(CNParam *param = NIL)
    { return param ? new CNSDLProcess(param) : new CNSDLProcess; }
     
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};



// now the inline functions

// get/set state
inline int CNSDLProcess::state() { return actual_state; }
inline void CNSDLProcess::state(int new_state) { actual_state = new_state; }

inline int CNSDLProcess::type() { return p_type; }


// called by SDLManager (indirect function call)
inline int CNSDLProcess::signalhandler(int signal)
{
    _global_pointer_to_actual_sdlsignalhandler_ = handler;
    return (this->*_global_pointer_to_actual_sdlsignalhandler_)(signal);
}


#endif /**__CNSDLProcess_h**/
