//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Normal.h,v 0.22 1994/07/22 09:20:28 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNNormal --- CNNormal (Gaussian) distributed random numbers
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************
 * original Copyright:
 * -------------------
 * Copyright (C) 1988 Free Software Foundation
 *    written by Dirk Grunwald (grunwald@cs.uiuc.edu)
 * 
 * This file is part of the GNU C++ Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 **EHEADER********************************************************************/

#ifndef __Normal_h
#define __Normal_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>
#include <CNCL/Random.h>		// Base class

extern CNClassDesc CN_NORMAL;	// CNClass CNNormal description
 


/*
 * The class CNNormal
 */

class CNNormal : public CNRandom
{
protected:
    double pMean;
    double pVariance;
    double pStdDev;

public:
    double mean();
    double mean(double x);
    double variance();
    double variance(double x);
    virtual double operator()();
  
    // Private members
private:
    char haveCachedCNNormal;
    double cachedCNNormal;

    /***** Constructors ******************************************************/
public:
    CNNormal();                                   // Default constructor
    CNNormal(double xmean, double xvariance, CNRNG *gen);
    CNNormal(CNParam *param);			// CNParam constructor

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_NORMAL;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_NORMAL ? TRUE : CNRandom::is_a(desc);
    };
        
    static CNNormal *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNNormal *)obj;
#   else
	return (CNNormal *)( !obj || obj->is_a(CN_NORMAL)
	       ? obj : fatal_type(obj->class_desc(), CN_NORMAL) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNNormal(param) : new CNNormal; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};



inline CNNormal::CNNormal()
	 : CNRandom((CNRNG*)NIL)
{
    pMean = 0;
    pVariance = 0;
    pStdDev = 0;
    haveCachedCNNormal = 0;
}
    


inline CNNormal::CNNormal(CNParam *param)
	 : CNRandom((CNRNG*)NIL)
{
    pMean = 0;
    pVariance = 0;
    pStdDev = 0;
    haveCachedCNNormal = 0;
}



inline CNNormal::CNNormal(double xmean, double xvariance, CNRNG *gen)
    : CNRandom(gen)
{
    pMean = xmean;
    pVariance = xvariance;
    pStdDev = sqrt(pVariance);
    haveCachedCNNormal = 0;
}



inline double CNNormal::mean() { return pMean; };
inline double CNNormal::mean(double x) {
    double t=pMean; 
    pMean = x;
    return t;
}

inline double CNNormal::variance() { return pVariance; }
inline double CNNormal::variance(double x) {
    double t = pVariance; 
    pVariance = x;
    pStdDev = sqrt(pVariance);
    return t;
};


#endif /**__Normal_h**/
