//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Geometric.h,v 0.22 1994/07/22 09:20:28 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNGeometric --- CNGeometric distributed random numbers
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************
 * original Copyright:
 * -------------------
 * Copyright (C) 1988 Free Software Foundation
 *    written by Dirk Grunwald (grunwald@cs.uiuc.edu)
 * 
 * This file is part of the GNU C++ Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 **EHEADER********************************************************************/

#ifndef __Geometric_h
#define __Geometric_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Random.h>		// Base class

extern CNClassDesc CN_GEOMETRIC;	// CNClass CNGeometric description


/*
 * The class CNGeometric
 */

class CNGeometric : public CNRandom
{
protected:
    double pMean;

public:
    double mean();
    double mean(double x);

    virtual double operator()();

    /***** Constructors ******************************************************/
public:
    CNGeometric();				// Default constructor
    CNGeometric(CNParam *param);			// CNParam constructor
    CNGeometric(double mean, CNRNG *gen);

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_GEOMETRIC;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_GEOMETRIC ? TRUE : CNRandom::is_a(desc);
    };
        
    static CNGeometric *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNGeometric *)obj;
#   else
	return (CNGeometric *)( !obj || obj->is_a(CN_GEOMETRIC)
	       ? obj : fatal_type(obj->class_desc(), CN_GEOMETRIC) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNGeometric(param) : new CNGeometric; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


inline CNGeometric::CNGeometric(double mean, CNRNG *gen) : CNRandom(gen)
{
  pMean = mean;
}

inline CNGeometric::CNGeometric() : CNRandom((CNRNG*)NIL)
{
    pMean = 0;
}

inline CNGeometric::CNGeometric(CNParam *param) : CNRandom((CNRNG*)NIL)
{
    pMean = 0;
}


inline double CNGeometric::mean() { return pMean; }
inline double CNGeometric::mean(double x) {
  double tmp = pMean;
  pMean = x; 
  return tmp;
}

#endif /**__Geometric_h**/



