//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: DiscUniform.h,v 0.22 1994/07/22 09:20:28 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNDiscUniform --- Discrete uniform distributed random numbers
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************
 * original Copyright:
 * -------------------
 * Copyright (C) 1988 Free Software Foundation
 *    written by Dirk Grunwald (grunwald@cs.uiuc.edu)
 * 
 * This file is part of the GNU C++ Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 **EHEADER********************************************************************/

#ifndef __DiscUniform_h
#define __DiscUniform_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Random.h>		// Base class

extern CNClassDesc CN_DISCUNIFORM;	// CNClass CNDiscUniform description


/*
 * The class CNDiscUniform
 */

class CNDiscUniform : public CNRandom
{
public:

    long low();
    long low(long x);
    long high();
    long high(long x);
    virtual double operator()();

    // Private members
private:
    long pLow;
    long pHigh;
    double delta;

    /***** Constructors ******************************************************/
public:
    CNDiscUniform();   				// Default constructor
    CNDiscUniform(CNParam *param); 			// CNParam constructor
    CNDiscUniform(long low, long high, CNRNG *gen);

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_DISCUNIFORM;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_DISCUNIFORM ? TRUE : CNRandom::is_a(desc);
    };
        
    static CNDiscUniform *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNDiscUniform *)obj;
#   else
	return (CNDiscUniform *)( !obj || obj->is_a(CN_DISCUNIFORM)
	       ? obj : fatal_type(obj->class_desc(), CN_DISCUNIFORM) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNDiscUniform(param) : new CNDiscUniform; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


inline CNDiscUniform::CNDiscUniform(long low, long high, CNRNG *gen)
    : CNRandom(gen)
{
    pLow = (low < high) ? low : high;
    pHigh = (low < high) ? high : low;
    delta = (pHigh - pLow) + 1;
}
inline CNDiscUniform::CNDiscUniform() : CNRandom((CNRNG*)NIL)
{
    pLow = 0;
    pHigh = 0;
    delta = 0;
}

inline CNDiscUniform::CNDiscUniform(CNParam *param) : CNRandom((CNRNG*)NIL)
{
    pLow = 0;
    pHigh = 0;
    delta = 0;
} 

inline long CNDiscUniform::low() { return pLow; }

inline long CNDiscUniform::low(long x)
{
    long tmp = pLow;
    pLow = x;
    delta = (pHigh - pLow) + 1;
    return tmp;
}

inline long CNDiscUniform::high() { return pHigh; }

inline long CNDiscUniform::high(long x)
{
    long tmp = pHigh;
    pHigh = x;
    delta = (pHigh - pLow) + 1;
    return tmp;
}


#endif /**__DiscUniform_h**/
