//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Determ.h,v 0.22 1994/07/22 09:20:28 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNDeterm --- CNDeterministic distributed "random" numbers
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __Determ_h
#define __Determ_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Random.h>		// Base class

extern CNClassDesc CN_DETERM;	// CNClass CNDeterm description


/*
 * The class CNDeterm
 */

class CNDeterm : public CNRandom
{
public:
    virtual double operator()() 
    {
	return xvalue;
    }
    double value() { return xvalue; }
    double mean()  { return xvalue; }
    double value(double x)
    {
	double xx = xvalue; xvalue = x; return xx;
    }
    double mean(double x)
    {
	double xx = xvalue; xvalue = x; return xx;
    }

    // Private members
private:
    double xvalue;

    /***** Constructors ******************************************************/
public:
	 CNDeterm() : xvalue(0), CNRandom((CNRNG*)NIL) {}		// Default constructor
	 CNDeterm(CNParam *param) : xvalue(0), CNRandom((CNRNG*)NIL) {}	// CNParam constructor
    CNDeterm(double x, CNRNG *gen) : xvalue(x), CNRandom(gen) {}

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_DETERM;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_DETERM ? TRUE : CNRandom::is_a(desc);
    };
        
    static CNDeterm *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNDeterm *)obj;
#   else
	return (CNDeterm *)( !obj || obj->is_a(CN_DETERM)
	       ? obj : fatal_type(obj->class_desc(), CN_DETERM) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNDeterm(param) : new CNDeterm; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


#endif /**__Determ_h**/
