//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: DLList.h,v 0.22 1994/07/22 09:20:16 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNDLList --- Double linked list
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __DLList_h
#define __DLList_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>
#include <CNCL/Object.h>		// Base class
#include <CNCL/DLObject.h>

extern CNClassDesc CN_DLLIST;	// CNClass CNDLList description


/*
 * The class CNDLList
 */

class CNDLList : public CNObject
{
  public:
    // Traverse list
    CNDLObject *first() const
    {
	return pfirst;
    }
    CNDLObject *last() const
    {
	return plast;
    }
    CNDLObject *next(CNDLObject *link) const
    {
	return link->pnext;
    }
    CNDLObject *prev(CNDLObject *link) const
    {
	return link->pprev;
    }

    // Check for empty list
    bool empty() const
    {
	return pfirst == NIL;
    }
    
    // Return # of items in list
    unsigned long length() const
    {
	return count;
    }
    
    // Add items
    CNDLObject *append(CNObject *obj);
    CNDLObject *append(CNObject &obj);
    CNDLObject *prepend(CNObject *obj);
    CNDLObject *prepend(CNObject &obj);

    CNDLObject *append(CNDLObject *obj);
    CNDLObject *prepend(CNDLObject *obj);

    // Delete items
    CNDLObject *remove_object(CNDLObject *pos);
    CNDLObject *delete_object(CNDLObject *pos);
    void delete_all();
    void delete_all_w_obj();
    
    // Insert items
    CNDLObject *insert_before(CNDLObject *pos, CNObject *obj);
    CNDLObject *insert_before(CNDLObject *pos, CNObject &obj);
    CNDLObject *insert_before(CNDLObject *pos, CNDLObject *obj);
    CNDLObject *insert_after (CNDLObject *pos, CNObject *obj);
    CNDLObject *insert_after (CNDLObject *pos, CNObject &obj);
    CNDLObject *insert_after (CNDLObject *pos, CNDLObject *obj);

    // Check list
    bool ok();

    // Private members
  private:
    CNDLObject *pfirst;			// Pointer to first CNDLObject of list
    CNDLObject *plast;			// Pointer to last  CNDLObject of list
    unsigned long count;		// # of items in list

    /***** Constructors ******************************************************/
  public:
    CNDLList()                  : pfirst(NIL), plast(NIL), count(0) {}
    CNDLList(CNParam *param)    : pfirst(NIL), plast(NIL), count(0) {}
    CNDLList(const CNDLList &l) : pfirst(NIL), plast(NIL), count(0)
    { fatal(NIL, "can't copy CNDLObject object"); }
    ~CNDLList()
    { delete_all(); }


    /***** Member functions required by CNCL *********************************/
  public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_DLLIST;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_DLLIST ? TRUE : CNObject::is_a(desc);
    };
        
    static CNDLList *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNDLList *)obj;
#   else
	return (CNDLList *)( !obj || obj->is_a(CN_DLLIST)
	       ? obj : fatal_type(obj->class_desc(), CN_DLLIST) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNDLList(param) : new CNDLList; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


#endif /**__DLList_h**/
