/*=============================================================================

 F U Z Z Y   A R T M A P  (1 9 9 1)                  CAS/CNS Boston University 

  ** written by Ah-Hwee Tan  **

  ** Documented Oct 18, 1991 **
  ** revised    Dec 26, 1991 **

=============================================================================*/

#include <stdio.h>
#include <sys/types.h>
#include <math.h>
#include "ARTMAP.h"

float    matchFunction ();
float    choiceOrderFunction ();

void refresh_F2 ()
{
    int refresh_ART_x;
    int refresh_ART_y;

    for(refresh_ART_x=0; refresh_ART_x<2; refresh_ART_x++)
      for(refresh_ART_y = 0; refresh_ART_y < num_category[refresh_ART_x]+1; refresh_ART_y++)
	F2[refresh_ART_x][refresh_ART_y] = 0.0;
}

void init_ARTs()
{
    int init_ARTs_x;
    int init_ARTs_y;
    int init_ARTs_z;
    
    for(init_ARTs_x=0; init_ARTs_x<2; init_ARTs_x++)
      for(init_ARTs_z=0; init_ARTs_z<num_category[init_ARTs_x]+1; init_ARTs_z++)
	{
	  committed[init_ARTs_x][init_ARTs_z] = 0;
	  for(init_ARTs_y = 0; init_ARTs_y < num_att[init_ARTs_x]; init_ARTs_y++)
	    dn[init_ARTs_x][init_ARTs_z][init_ARTs_y] = dnInit;
	}

    rho[ARTa] = min_arho;
    rho[ARTb] = brho;
}

void init_ARTB()
{
  int  i, j;

  refresh_F2 ();
  if (two_binary_categories) /* If there are two output categories with values
				(0,1), (1,0), this sets the first ARTB category
				to (0,1) and the second to (1,0).  This is done
				  in order to keep track of errors by prediction. */
    {
      pattern[1][0] = 0.0;  /* In order to keep track of statistics on  */
      pattern[1][1] = 1.0;  /* performance over repeated trials by prediction, */
      B_only(TRAIN);         /* I have initialized ART-B to have category 0 */
      /* code inputs (1,0) and category 1 code inputs */
      pattern[1][0] = 1.0;  /* (0,1).  These six lines of code should be removed */
      pattern[1][1] = 0.0;  /* if ART-B can receive inputs other than (0,1) or (1,0). */
	  B_only(TRAIN);
    }
  else
    {
      for (i=0; i<b_length; i++)
	{
	  for (j=0; j<b_length; j++)
	    {
	      pattern[1][j] = 0.0;
	      if (complement)
		pattern[1][j+b_length] = 1.0;
	    }
	  pattern[1][i] = 1.0;
	  if (complement)
	    pattern[1][i+b_length] = 0.0;
	  B_only (TRAIN);
	}
    }
}

float matchFunction (whichART, f2)
int whichART, f2;
{
    int matchFunction_x;
    float numerator;      /* the numerator of the match value */
    float denominator;    /* the denominator of the match value */

    numerator = 0.0;
    denominator = 0.0;

    for (matchFunction_x=0; matchFunction_x<num_att[whichART]; matchFunction_x++)
      {
	denominator += pattern[whichART][matchFunction_x];
	if (pattern[whichART][matchFunction_x] < dn[whichART][f2][matchFunction_x])
	  numerator += pattern[whichART][matchFunction_x];
	else
	  numerator += dn[whichART][f2][matchFunction_x];
      }
    return (numerator/denominator);
}


float choiceOrderFunction (whichART, f2)
int whichART, f2;
{
  int choiceOrderFunction_x;
  float numerator;   /* the numerator of the choice value */
  float denominator; /* the denominator of the choice value */
  
  if (F2[whichART][f2]==-1.0)
    return -1;
  else
    {
      numerator = 0.0;
      denominator = 0.0;
      for (choiceOrderFunction_x = 0; choiceOrderFunction_x < num_att[whichART]; choiceOrderFunction_x++)
	{
	  denominator += dn[whichART][f2][choiceOrderFunction_x];
	  if (pattern[whichART][choiceOrderFunction_x] < dn[whichART][f2][choiceOrderFunction_x])
	    numerator += pattern[whichART][choiceOrderFunction_x];
	  else
	    numerator += dn[whichART][f2][choiceOrderFunction_x];
	}
      
      denominator += Alpha;
      return (numerator/denominator);
    }
}

void learn (whichART, f2)
int whichART, f2;
{
  int   learn_x;
  float cur_rate;
  
  if (committed[whichART][f2])
    cur_rate = rate;
  else
    cur_rate = 1.0;
  
  if (!no_learn_if_wrong || wrong)
    {
      for (learn_x = 0; learn_x < num_att[whichART]; learn_x++)
	if (pattern[whichART][learn_x] < dn[whichART][f2][learn_x])
	  dn[whichART][f2][learn_x] = (1.0-cur_rate)*dn[whichART][f2][learn_x]
	    + cur_rate*pattern[whichART][learn_x];
    }
  committed[whichART][f2] = 1;
}

int ARTreset(whichART, f2)
int whichART, f2;
{
  float m;

  /* The ART1 has received some input to mismatch against */

  if (matchFunction(whichART,f2) < rho[whichART])
    {
      F2[whichART][f2] = -1.0;
      /*  fprintf(temp,"RESET: ARTreset(%d,%d).\n",whichART,f2);   */
      return TRUE;
    }
  else
      return FALSE;
}

int ART (whichART,phase)
int whichART, phase;
{
    float  maxChoice;     /* highest choice value found so far */
    float  curChoice;     /* choice value of f2 node currently under consideration */
    int    mismatch;         /* binary: 0 means no chosen node has matched yet */
    int    winner;           /* the winning f2 node */
    int    f2;               /* the current f2 node under consideration */

    for (f2=0; f2<=num_category[whichART]; f2++)
      F2[whichART][f2] = choiceOrderFunction(whichART,f2);

    do {
	maxChoice = -1.0;
	winner = -1;
	for (f2=0; f2<=num_category[whichART]; f2++)
	  {
	    if (maxChoice < F2[whichART][f2])
	      {
		maxChoice = F2[whichART][f2];
		winner = f2;
	      }
	  }
	mismatch = ARTreset(whichART,winner);
      } while (mismatch);

    if (winner==num_category[whichART] && phase==TRAIN)
      {
	num_category[whichART]++;
	realloc_memory (whichART);
      }
    return winner;
}







