/*	This file is part of the software similarity tester SIM.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
	$Header: pass2.c,v 2.4 92/06/30 16:16:44 dick Exp $
*/

#include	"cport.h"
#include	"private.h"
#include	"sim.h"
#include	"stream.h"
#include	"debug.h"
#include	"sortposlist.h"

extern int ntexts;
extern struct text *text;

PRIVATE int next_eol();

pass2() {
	int n;
	
	for (n = 0; n < ntexts; n++) {
		register struct text *txt = &text[n];
		register struct position *pos;
		register unsigned int old_tk_cnt;
		long old_fs_pos;
		unsigned int old_nl_cnt;
	
		if (!txt->tx_pos)	/* no need to scan the file */
			continue;

		if (!OpenText(2, txt)) {
			printf("*** File %s disappeared\n", txt->tx_fname);
		}
		/* sets lex_nl_cnt, lex_tk_cnt, lex_fs_pos */

#ifdef	DB_POS
		printf("pos list before sorting\n");
		db_pr_pos_list(txt->tx_pos);
#endif	/* DB_POS */

		sort_pos_list(&txt->tx_pos);

#ifdef	DB_POS
		printf("pos list after sorting\n");
		db_pr_pos_list(txt->tx_pos);
#endif	/* DB_POS */

#ifdef	DB_NL_BUFF
		db_pr_nl_buff(txt->tx_nl_start, txt->tx_nl_limit);
#endif	/* DB_NL_BUFF */

		old_tk_cnt = 0;
		old_fs_pos = 0L;
		old_nl_cnt = 1;
		pos = txt->tx_pos;
		while (pos) {
			/* we scan the pos list and the file in parallel */
			register unsigned int tk_cnt = pos->ps_tk_cnt;

			if (old_tk_cnt <= tk_cnt && tk_cnt < lex_tk_cnt) {
				/* pos refers to this line */

				/* fill in the pos */
				switch (pos->ps_type) {
				case 0:	/* first token of run */
					pos->ps_fs_pos = old_fs_pos;
					pos->ps_nl_cnt = old_nl_cnt;
					break;
				case 1:	/* last token of run */
					pos->ps_fs_pos = lex_fs_pos;
					pos->ps_nl_cnt = lex_nl_cnt;
					break;
				}
				/* and shift to next pos */
				pos = pos->ps_next;
			}
			else {
				/* no more pos's to be filled on this line */

				/* shift the administration */
				old_nl_cnt = lex_nl_cnt;
				old_tk_cnt = lex_tk_cnt;
				old_fs_pos = lex_fs_pos;
				/* and shift to next line */
				if (!next_eol()) break;
#ifdef	DB_POS
				db_pr_lex(txt->tx_fname);
#endif	/* DB_POS */
			}
		}

#ifdef	DB_POS
		printf("pos list after scanning\n");
		db_pr_pos_list(txt->tx_pos);
#endif	/* DB_POS */

		if (pos) {
			/* not all pos's were consumed */
			printf("*** File %s modified\n", txt->tx_fname);
		}
		CloseText(2, txt);
	}
}

PRIVATE int
next_eol()
{
	while (NextTextToken(2)) {
		if (TOKEN_EQ(lex_token, EOL)) return 1;
	}
	return 0;
}

