%{
/*	This file is part of the software similarity tester SIM.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
	$Header: lisplang.l,v 2.2 91/09/17 21:32:51 dick Exp $
*/

/*
	LISP language front end for the similarity tester.
	Author:	Gertjan Akkerman <akkerm@cs.vu.nl>
	Date:	Thu, 9 Apr 87 11:15:23 MDT
*/

#include	"cport.h"
#include	"private.h"
#include	"token.h"
#include	"stream.h"
#include	"lex.h"

/* Language-dependent Code */
#include	"idf.h"

CONST PRIVATE struct idf reserved[] = {
	"append",	NORM('a'),
	"append1",	NORM('b'),
	"atom",		NORM('t'),
	"car",		NORM('h'),
	"cdr",		NORM('t'),
	"cond",		NORM('c'),
	"cons",		NORM('s'),
	"defun",	NORM('u'),
	"do",		NORM('d'),
	"eq",		NORM('e'),
	"equal",	NORM('e'),		/* See eq */
	"for",		NORM('f'),
	"if",		NORM('i'),
	"list",		NORM('l'),
	"nconc",	NORM('n'),
	"rplaca",	NORM('A'),
	"rplacd",	NORM('D')
};

/* Token sets for module algollike */
CONST TOKEN Headers[] = {
	NORM('('),
	NORM('['),
	NOTOKEN
};
CONST TOKEN Trailers[] = {
	NORM(')'),
	NORM(']'),
	NOTOKEN
};
CONST TOKEN Openers[] = {
	NORM('('),
	NORM('['),
	NOTOKEN
};
CONST TOKEN Closers[] = {
	NORM(')'),
	NORM(']'),
	NOTOKEN
};

/* Language-INdependent Code */

yystart() {
	BEGIN INITIAL;
}

PRIVATE int
yywrap() {
	return 1;
}

%}

%Start	Comment

AnyQuoted	(\\.)
StrChar		([^"\n\\]|{AnyQuoted})
ChrChar		([^'\\]|{AnyQuoted})

IdfChar		([^\ \t\n\.\(\)\[\]\'\"\|])

EscIdf		(({IdfChar}|\\.)+)
QuotIdf		("|"[^\|\n]*"|")
Idf		({EscIdf}|{QuotIdf})

%%

";".*$	{			/* comment */
	}

\"{StrChar}*\"	{		/* strings */
		return_ch('"');
	}

{Idf}	{			/* identifier */
		return_tk(idf_in_list(yytext, reserved, IDF));
	}

[ \t]	{			/* layout */
	}

\n	{			/* count newlines */
		return_eol();
	}

.	{			/* copy other text */
		if (!(yytext[0]&0200)) return_ch(yytext[0]);
	}

%%

