#ifndef GLOBAL_H
#define GLOBAL_H


/*
 * General include files.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


/*
 * Change "VARS" to represent the maximum number of variables and change "K"
 * to the maximum domain sizes for each network.
 */
#define VARS      50
#define N         (VARS+1)
#define K         5


/*
 * Abstract data types to represent the constraint network, the constraints
 * along each edge, and the solution.
 */
typedef char           CONSTRAINT[K][K];
typedef CONSTRAINT     NETWORK[N][N];
typedef char           SOLUTION[N];


/*
 * Type definition for the two types of timer available in the program.
 */
typedef enum type_timer {REAL, VIRTUAL} TIMER_TYPE;


/*
 * Structures to hold information when an entry in the constraint network
 * is changed from a 1 to a 0 during the path consistency algorithms.
 */
typedef struct list {
    int i, j, x, y;
    struct list *next;
} LIST;

typedef struct head {
    LIST *list;
    struct head *next;
} HEAD;


/*
 * Truncated function prototyping for the available backtracking methods.
 * These methods should not be called directly but rather through the
 * "backtrack" function.
 */
int BJ();
int BM();
int BM_BJ();
int BM_CBJ();
int BM_GBJ();
int BT();
int CBJ();
int FC();
int FC_BJ();
int FC_CBJ();
int FC_GBJ();
int FCarc();
int FCpath();
int GBJ();


/*
 * Truncated function prototypes for type of domain ordering.  Use these with
 * the "order_domains" function.  These functions correspond to the possible
 * heuristics.
 */
int domain_convexity();
int domain_degree();
int domain_satisfy();


/*
 *  Function prototypes for routines that assign a heuristic value to the
 *  relation on an edge and for strategy routines, both used in ordering
 *  the variables.  The first three correspond to the three possible
 *  heuristics applicable to variable ordering.  The last three function
 *  prototypes correspond to the three methods available by which to sort
 *  the variables: sort, width with largest first, width with smallest
 *  last.  These functions should only be used in conjunction with the
 *  "order_variables" function.
 */
int variable_convexity( /* CONSTRAINT R, int k */ );
int variable_degree(    /* CONSTRAINT R, int k */ );
int variable_satisfy(   /* CONSTRAINT R, int k */ );
void glf(  /* int n, int edges[N][N], struct info nodes[N] */ );
void gsl(  /* int n, int edges[N][N], struct info nodes[N] */ );
void sort( /* int n, int edges[N][N], struct info nodes[N] */ );


/*
 * Other function prototypes for cross-file compilation.
 */
int pre_arc();
int pre_path();
int time_expired();
void analyze();
void generate_C();
void generate_Q();
void generate_R();
void generate_S();
void order_domains();
void order_variables();
void process_solution();
void solve();
void start_timers();
double elapsed_time();


/*
 * External declarations for cross-file access to global variables.
 */
extern unsigned int checks, count;


/*
 * Macro to check each new memory allocation.  Exit the program if not enough
 * memory can be attained.
 */
#define new_malloc(x, y)   { \
                               x = (y *)malloc(sizeof(y)); \
                               if (x == NULL) { \
                                   printf("Memory allocation error.\n"); \
                                   exit(1); \
                               } \
                           }


#endif
