
#include "global.h"


/*
 * Stack functions for arc consistency where only variables have to be stored.
 * Push pushes a variable on the stack and marks it as being on the stack,
 * unless the variable was already on the stack, in which case it is not added
 * again.  Pop gets the top value off the stack.  The stack_empty function
 * returns whether the stack is empty or not.
 */
#define push(a)       if (!on_stack[a]) { \
                          top++; \
                          stack[top] = a; \
                          on_stack[a] = 1; \
                      }

#define pop(a)        { \
			  a = stack[top]; \
			  on_stack[a] = 0; \
			  top--; \
		      }

#define init_stack()  {\
			  top = 0;\
			  for( i = 1; i <= n; i++ )\
			      on_stack [i] = 0;\
		      }

#define stack_empty() (top == 0)


static int stack[N], on_stack[N], top = 0;


/*
 * This function determines whether given a specific edge, there exists some
 * instantiation for "y" given the instantiation for "x".  It loops through
 * all the value of the "y" variable.
 */
static int value(C, k, x, y, i)
NETWORK C;
int i, k, x, y;
{
    int j;

    for (j = 0; j < k; j++)
        if (C[x][y][i][j] && C[y][y][j][j])
            return(1);
    return(0);
}


/*
 * Determine which domain values for variable "x" can be eliminated by
 * considering the edge between "x" and "y".  The number of values deleted
 * from the domain is returned.  Each possible domain value of "x" is
 * considered separately in the loop.
 */
static int revise(C, k, x, y)
NETWORK C;
int k, x, y;
{
    int i, delete = 0;

    for (i = 0; i < k; i++)
        if (C[x][x][i][i] == 0)
            continue;
        else if (value(C, k, x, y, i) == 0) {
            C[x][x][i][i] = 0;
            delete++;
        }

    return(delete);
}


/*
 * Function to perform complete arc consistency on entire constraint network.
 * The process considers each "half" of the constraint network separate as also
 * done by Mackworth.  It processes each edge using a stack to store edges
 * still to be examined.  It first pushes all "edges" to be examined.  Then, it
 * processes the edges one by one, placing variables back on the stack if
 * necessary (i.e. their domain values have changed).  Note that edges simply
 * correspond to the edges leading into the variable stored on the stack (thus
 * only these variables need to be stored instead of all edges).  The function
 * returns whether the network is consistent or not by checking if any
 * variables have their domains empty.  Note that if a variable x has any of
 * its domain values eliminated, this is noted in the constraint C[x][x], by
 * eliminating this value for the original "I" matrix.
 */
int pre_arc(C, n, k)
NETWORK C;
int n, k;
{
    int i, j, count;

    init_stack();
    for (i = 1; i <= n; i++)
        push(i);
    while (!stack_empty()) {
        pop(j);
        for (i = 1; i <= n; i++)
            if (i != j && revise(C, k, i, j))
                push(i);
    }
    for (i = 1; i <= n; i++) {
        count = 0;
        for (j = 0; j < k; j++)
            count += C[i][i][j][j];
        if (count == 0)
            return(0);
    }
    return(1);
}
