/*
Copyright (C) 1992 University of Maryland.

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies, and
that both that copyright notice and this permission notice appear
in supporting documentation.  The author makes no representations
about the suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty. Your use of
this software signifies that you are willing to take the risks of
using this software by yourself.

THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE
USE OR PERFORMANCE OF THIS SOFTWARE.
*/

/* sortchange.c */

/* This is a filter program which sorts and prints out changed rules */
 /* only. Changed rules are rules which will lead to a change of state */
 /* in next epoch. */

#include <stdio.h>

struct board_type {
  char c, t, r, b, l, a;
} board[500], temp;

main()
{
  int count, save;
  int i, j, x, y;
  char c, t, r, b, l, a, buf[100];
  
  count = 0; save = 0;
  while (fgets(buf, 100, stdin)) {
    if (strncmp(buf+6, "->", 2)==0) {
      count++;
      sscanf(buf, "%c%c%c%c%c -> %c", &c, &t, &r, 
	     &b, &l, &a);
      if (c!=a) { 
	board[save].c = c; board[save].t = t; board[save].r = r;
	board[save].b = b; board[save].l = l; board[save].a = a;
	save++;
      } 
    }
  }

  for (i=0; i<save-1; i++)
    for (j=i+1; j<save; j++) {
      x = board[i].a * 65536 + board[i].c * 256 + board[i].l;
      y = board[j].a * 65536 + board[j].c * 256 + board[j].l;
      if (x>y) {
	temp.c = board[i].c; board[i].c = board[j].c; board[j].c = temp.c;
	temp.t = board[i].t; board[i].t = board[j].t; board[j].t = temp.t;
	temp.r = board[i].r; board[i].r = board[j].r; board[j].r = temp.r;
	temp.b = board[i].b; board[i].b = board[j].b; board[j].b = temp.b;
	temp.l = board[i].l; board[i].l = board[j].l; board[j].l = temp.l;
	temp.a = board[i].a; board[i].a = board[j].a; board[j].a = temp.a;
      }
    }

  for (i=0; i<save; i++)
    printf("%c%c%c%c%c -> %c\n", board[i].c, board[i].t, board[i].r,
	   board[i].b, board[i].l, board[i].a);
  fprintf(stderr, "count = %d, save = %d\n", count, save);

}

