;; This file defines the verbs and case-frames used  in the dating package
;; 

(in-package :dating)

;; set up the current dating world

(defvar *default-dating-world-name* (gensymbol "dating-world"))
(defvar *current-dating-world-name* *default-dating-world-name*)
(defvar *current-dating-world* nil)
(setq *current-dating-world*  
  (define-unit  *default-dating-world*  
  (member-of 'dating-worlds)))


;; define  the action of seeking
;; There  is a "seeker"  who seeks the "seekee" to do "seek-activities
;; The "seeker" is a real person,  who's ideal-person is the "seekee" 

(define-unit seeking
  (member-of 'collections)
  (supersets 'actions))

(define-unit seekers
  (member-of 'collections)
  (supersets 'humans))

(define-unit seekees
  (member-of 'collections)
  (supersets 'humans))


(define-unit seekee
  (member-of 'single-valued-slots)
  (must-be 'anythingp)
  (makes-sense-for 'seeking)
  (put-demons '(assert-value %value% member-of seekees))
  (put-demons '(introduce! %value%))
  (put-demons '(assert-value %value% ontological-status idealized-person)))

(define-unit seek-activities
  (member-of 'many-valued-slots)
  (must-be 'anythingp)
  (makes-sense-for 'seeking))


(define-unit seeker
  (member-of 'single-valued-slots)
  (must-be 'anythingp)
  (makes-sense-for 'seeking)
  (put-demons '(assert-value %value% member-of seekers))
  (put-demons '(assert-value %value% ontological-status real-person))
  (put-demons '(introduce! %value%))
;  (put-demons '(assert-value *current-dating-world* potential-dates %value%))
  (put-demons `(assert-value %value% my-dating-world ,*current-dating-world* ))
  (structure '(ideal-person seekee))
  (structure '(does-activities seek-activities)))


(define-word "SEEK"
  (member-of 'huh::infinitives)
  (past-tense (register-word "SOUGHT"))
  (case-frames
   '(seeking (seeker) (seekee) (seek-activities)  
     (for seek-activities))
     ))

(define-word "DESIRE"
  (member-of 'huh::infinitives)
  (case-frames
   '(seeking (seeker) (seekee) (seek-activities)  
     (for seek-activities))
     ))
(define-word "NEED"
  (member-of 'huh::infinitives)
  (case-frames
   '(seeking (seeker) (seekee) (seek-activities)  
     (for seek-activities))
     ))
(define-word "WANT"
  (member-of 'huh::infinitives)
  (case-frames
   '(seeking (seeker) (seekee) (seek-activities)  
     (for seek-activities))
))
;; define 3rd person present singular of regular verbs

(define-unit 3rd-person-singular-present
  (member-of 'single-valued-slots)
  (makes-sense-for 'words)
  (must-be 'words)
  (put-demons '(assert-value %unit% member-of infinitives))
  (put-demons '(assert-value %value% member-of verbs))
  (to-compute-value 'add-s-to-make-3rd-person-singular-present)
  (inverse-slot (make-unit '3rd-person-singular-present-of
		  (member-of 'single-valued-slots)
		  (genl-slots 'verb-root))))
(defun add-s-to-make-3rd-person-singular-present (word slot)
  (declare (ignore slot))
  (register-word (concatenate 'string (symbol-name word) "S")))
    
