;; This file describes  the  traits a person may have "has-traits" or desire in  another
;; "wants-traits"

;; the package "dating" is loaded
(in-package :dating)

;; stuff for eager composition

(define-unit demanded-inverse
  (english-description "The inverse of a slot.")
  (works-like 'prototypical-slot)
  (makes-sense-for 'slotp)
  (must-be         'slotp)
  (genl-slots 'inverse-slot)
  (to-compute-value 'make-an-inverse))

(defun make-an-inverse (slot is)
  (declare (ignore is))
  (make-unit (fsymbol (symbol-package slot) "INVERSE-OF-~A" slot)
    (works-like 'prototypical-set-slot)))

(define-unit eager-composition-of
  (member-of 'single-valued-slots)
  (makes-sense-for 'slotp)
  (put-demons '(assert-value (cadr %value%) 'put-demons
                `(assert-each-value %value% ',(car %value%) %unit% ,%unit%)))
  (put-demons '(assert-value (car %value%) 'put-demons
                `(assert-on-each %unit% ,(get-value (cadr %value%)
                                                    'demanded-inverse)
                  ,%unit% %value%))))



(define-unit ideal-person
  (member-of 'single-valued-slots)
  (makes-sense-for 'humans)
;; should refine the must-be
  (must-be 'anythingp))

(define-unit traits
  (member-of 'collections))

(define-unit has-traits
  (member-of  'many-valued-slots)
  (makes-sense-for 'humans)
  (must-be 'traits)
  )

(define-unit wants-traits 
  (member-of 'many-valued-slots)
  (eager-composition-of '(has-traits ideal-person )))

(define-unit warm
  (member-of 'traits))

(define-unit funny
  (member-of 'traits))

(define-unit sense-of-humor
  (member-of 'traits))

(define-unit sexy
  (member-of 'traits))

(define-unit passionate
  (member-of 'traits))

(define-unit mean
  (member-of 'traits))

(define-unit cold
  (member-of 'traits))

(define-unit domineering
  (member-of 'traits))

(define-unit melancholy
  (member-of 'traits))

(define-unit ambitious
  (member-of 'traits))

(define-unit vivacious
  (member-of 'traits))

(define-unit angry
  (member-of 'traits))

(define-unit intelligent
  (member-of 'traits))

(define-unit sensitive
  (member-of 'traits))

(define-unit politically-active
  (member-of 'traits))

(define-unit athletic 
  (member-of 'traits))

(define-unit outgoing
  (member-of 'traits))

(define-unit strong
  (member-of 'traits))

(define-unit muscular
  (member-of 'traits))

(define-unit morbid 
  (member-of 'traits))

(define-unit alienated
  (member-of 'traits))

(define-unit fastidious
  (member-of 'traits))

(define-unit unkempt
  (member-of 'traits))

(define-unit orderly
  (member-of 'traits))

(define-unit quiet
  (member-of 'traits))

(define-unit loud
  (member-of 'traits))

(define-unit spiritual
  (member-of 'traits))

(define-unit trancendent
  (member-of 'traits))

(define-unit stupid
  (member-of 'traits))

(define-unit obnoxious
  (member-of 'traits))

