;; definitions needed for parsing dating sentences in HUH are given
;; the package "dating" is loaded
(in-package :dating)

(import 'huh::sentence)
(import 'huh::noun-phrase)
(import 'huh::adjectives)
(import 'huh::modifiers)
(import 'huh::copy-object)


;; define parsers for numeric age, weight and height
;; deal later with other units (e.g. metric, feet and inches)
;; Need a way to deal with things  like "40-ish"


(define-parser (huh::adjectives numeric-age-phrase)
  ((a1 (satisfies number-words))
   (year-phrase (is-exactly-one-of year years))
   (old (noise-word old)))
   (list `(age ,(get-value a1 'numeric-value))))

(define-parser (huh::adjectives numeric-weight-phrase)
  ((a1 (satisfies number-words))
   (units (is-exactly-one-of pounds lbs pound  lb)))
   (list `(weight ,(get-value a1 'numeric-value))))

(define-parser (huh::adjectives numeric-height-phrase)
  ((a1 (satisfies number-words))
   (units (is-exactly-one-of inches inch))
   (w2 (noise-word tall)))
   (list `(height ,(get-value a1 'numeric-value))))

(register-word "yet")
(register-word "but")


(define-parser (adjectives some)
    ((adj (interpretation adjective-interpretation))
     (comma (noise-word |,|))
     (conjuction (noise-word AND))
     (conjuction (noise-word YET))
     (conjuction (noise-word BUT))
     (remainder adjectives))
  (cons `(,(car adj) ',(cadr adj)) remainder))

;;; define parsers for various personals abbreviations: e.g. SF
;;; these form the category "pers-noun"

(define-parser (huh::pers-noun SM-phrase)
  (( sm-word (is-exactly-one-of SM)))
  '( create-object  (member-of 'men) (sexual-orientation 'heterosexual)))

(register-word "SM")

(define-parser (huh::pers-noun GM-phrase)
  (( gm-word (is-exactly-one-of GM)))
  '(create-object  (member-of 'men) (sexual-orientation 'homosexual)))

(register-word "GM")


(define-parser (huh::pers-noun SF-phrase)
  (( sf-word (is-exactly-one-of SF SW)))
  '(create-object  (member-of 'women) (sexual-orientation 'heterosexual)))

(register-word "SF")
(register-word "SW")

(define-parser (huh::pers-noun LF-phrase)
  (( lf-word (is-exactly-one-of LF LW GF GW)))
  '(create-object  (member-of 'women) (sexual-orientation 'homosexual)))

(register-word "LF")
(register-word "LW")
(register-word "GF")
(register-word "GW")

(define-parser (huh::pers-noun BiM-phrase)
  (( word (is-exactly-one-of BiM)))
  '(create-object  (member-of 'men) (sexual-orientation 'bisexual)))

(register-word "BiM")


(define-parser (huh::pers-noun BiF-phrase)
  (( word (is-exactly-one-of BiF BiW)))
  '(create-object  (member-of 'women) (sexual-orientation 'bisexual)))

(register-word "BiF")
(register-word "BiW")

;; allow SWM 32 etc. as a "pers-noun"
  
(define-parser (huh::pers-noun pers-ident-with-age)
  ((the-pers-ident huh::pers-noun)
   (comma (noise-word |,|))
   (the-age (satisfies number-words)))
  `(extend-object ,the-pers-ident (age (get-value ',the-age 'numeric-value))))


;; build up noun phrases using "pers-nouns" and "adjectives"

;; a single personals identifier can constitute a noun phrase
(define-parser (huh::noun-phrase pers-ident)
  ((the-pers-ident huh::pers-noun))
  the-pers-ident)
                           
;; allow noun phrases such as "tall  intelligent SBF"
(define-parser (huh::noun-phrase adjectives-per-noun)
  ((adjectives adjectives)
   (noun  huh::pers-noun))
  `(extend-object ,noun ,@adjectives))

;; allow noun phrases such as "SBF, tall  intelligent"
(define-parser (huh::noun-phrase per-noun-adjectives)
  ((noun  huh::pers-noun)
   (comma (noise-word |,|))
   (adjectives adjectives))
  `(extend-object ,noun ,@adjectives))



;; allow noun phrases such as "SBF  55, tall  intelligent"
;; I would think in theory the preceding parser could handle it, 
;; since "SBF 55" is a "pers-noun", but it doesn't seem to.

(define-parser (huh::noun-phrase pers-ident-with-age-adjs)
  ((the-pers-ident huh::pers-noun)
   (comma (noise-word |,|))
   (the-age (satisfies number-words))
   (adjectives adjectives))
  `(extend-object ,the-pers-ident (age (get-value ',the-age 'numeric-value))

                  ,@adjectives))   



;; For things like activites, we don't want to create an instance
;; a person will have 'does-activities 'skiing, not skiing.1

(define-parser (prepositional-phrases object-is-class)
    ((prep (is-exactly-one-of by for))
     (class (interpretation class-interpretation))
     (j1 (noise-word and))
     (comma (noise-word |,|))
     (more prepositional-phrases))
  (cons (list prep `(quote ,class)) more))


(register-word "am")
(register-word "must be")
(register-word "should be")



;; now build up sentences
;; allow "am"  for 1st person sentences, also "must be" and "should be"

;; For instance, "The robot is a big toaster."
(define-parser (sentence is-a)
    ((subject noun-phrase)
     (assertive (is-exactly-one-of is am |must be| |should be|))
     (complement noun-phrase)
     (punctuation (the-end-of-the-sentence |.|)))
  `(copy-object ,subject ,complement))


;; For instance, "The robot is big."
;; Also allow "I am big."   (later should have agreement, e.g. disallow "the robot am big")
;; check out use of "modifiers" verses "adjectives"
(define-parser (sentence is-adj)
    ((subject noun-phrase)
     (assertive (is-exactly-one-of is am |must be| |should be|))
     (adjectives adjectives)
     (punctuation (the-end-of-the-sentence |.|)))
  `(extend-object ,subject ,@adjectives))

 
;; Some general language extensions, taken from Marc Davis 

;;For instance "the robot is a big toaster, a good  friend, and   a red  dog
(define-parser (huh::sentence is-a-list)
    ((subject noun-phrase)
     (assertive (is-exactly-one-of is am |must be| |should be|))
     (complement compound-noun-phrase)
     (punctuation (the-end-of-the-sentence |.|)))
    (list* 'let `((sub ,subject))
           (loop  for c  in  complement collecting
                  `(copy-object sub ,c))))

(define-parser (huh::noun-phrase construct-determinerless-reference)
  ((adjectives adjectives)
   (noun (interpretation class-interpretation)))
  `(create-object (member-of ',noun) ,@adjectives))

(define-parser (huh::compound-noun-phrase construct-compound-reference)
  ((np noun-phrase)
   (comma (noise-word |,|))
   (conjuction (noise-word AND))
   (remainder compound-noun-phrase))
  `(,np ,@remainder))

(define-parser (huh::compound-noun-phrase no-noun-phrase)
  ()
  '())

;; end of Marc's stuff



;; do some resolution of discourse reference
;; assume first  person  references refer to the "seeker"
;; assume second and third  person references refer to the "seekee"

(define-parser (noun-phrase resolve-he)
  ((label (exactly-matches he))
   (reference (discourse-reference '((member-of 'seekees)))))
  `',reference)

(register-word "I")

(define-parser (noun-phrase resolve-I)
  ((label (exactly-matches I))
   (reference (discourse-reference '((member-of 'seekers)))))
  `',reference)

(define-parser (noun-phrase resolve-she)
  ((label (exactly-matches she))
   (reference (discourse-reference '((member-of 'seekees)))))
  `',reference)

(register-word "s/he")
(register-word "they")

(define-parser (noun-phrase resolve-other-3rd-person)
  ((label (is-exactly-one-of s/he they ))
   (reference (discourse-reference '((member-of 'seekees)))))
  `',reference)

(define-parser (noun-phrase resolve-2nd-person)
  ((label (is-exactly-one-of you))
   (reference (discourse-reference '((member-of 'seekees)))))
  `',reference)


;; Allow a request  for all of the matches  in the dating  world
;; e.g. "Find me all the matches."

(define-parser (sentence get-all-matches)
  ((w1 (is-exactly-one-of find get show))
   (w2 (noise-word me))
   (w3 (noise-word all))
   (w4 (noise-word the))
   (w5 (is-exactly-one-of matches connections))
   (punctuation (the-end-of-the-sentence |.|)))

  `(get-value  ',*current-dating-world* 'all-matches))

