;; This  file  defines the world of activities in which persons engage
;; Activities are  collections  in a subset/superset lattice
;; e.g. sports => skiing => downhill
;; Activities can have properties such as "indoor", "outdoor", and
;; "during-season",  which are inherited by subsets
;; We also allow for "kind of kind of activities" such as "winter-sportp"
;; which is a test which is satisfied  by anything which is a subset of
;; sports  which has a "during-season" of winter

;; the package "dating" is loaded
(in-package :dating)


;; a basic
(define-unit activities
  (member-of 'collections)
  )

;; define some slots for activities
;; these are inherited by subsets

(define-unit indoor
  ;;(works-like 'prototypical-slot)
  (member-of 'single-valued-slots)
  (makes-sense-for (get-value 'activities 'subset-test))
  (must-be 'booleanp)
)

(define-unit outdoor
  ;;(works-like 'prototypical-slot)
  (member-of 'single-valued-slots)
  (makes-sense-for (get-value 'activities 'subset-test))
  (must-be 'booleanp)
)

(define-unit seasons
  (member-of 'collections)
)

(define-unit during-season
  (member-of 'many-valued-slots)
  (makes-sense-for (get-value 'activities 'subset-test))
;;(pushes-through 'members)
  (pushes-through 'subsets)
  (must-be 'seasons)
)


;; define the seasons, they are members of the collections "seasons"
(define-unit fall
  (member-of 'seasons))

(define-unit winter
  (member-of 'seasons))

(define-unit spring
  (member-of 'seasons)) 

(define-unit summer
  (member-of 'seasons)) 



;; define the major categories of activities

(define-unit sports
  (member-of 'collections)
  (supersets 'activities))

(define-unit culture
  (member-of 'collections)
  (supersets 'activities))

(define-unit social-activities
  (member-of 'collections)
  (supersets 'activities))


;; define some  sports

(define-unit skiing
  (member-of 'collections)
  (supersets 'sports))

(define-unit x-country
  (member-of 'collections)
  (supersets 'skiing))

(define-unit downhill
  (member-of 'collections)
  (supersets 'skiing))

(define-unit tennis
  (member-of 'collections)
  (supersets 'sports)
  (during-season 'fall)
  (during-season 'summer)
  (during-season 'spring)
  )

(define-unit baseball
  (member-of 'collections)
  (supersets 'sports)
  (during-season 'fall)
  (during-season 'summer)
  (during-season 'spring)
  )

(define-unit football
  (member-of 'collections)
  (supersets 'sports)
  (during-season 'fall)
  )

(define-unit beachcombing
  (member-of 'collections)
  (supersets 'activities)
  (during-season 'summer)
  )

(define-unit ping-pong
  (member-of 'collections)
  (supersets 'sports)
  (during-season 'fall)
  (during-season 'summer)
  (during-season 'spring)
  (during-season 'winter)
  (indoor t)
  )


(define-unit water-skiing
  (member-of 'collections)
  (supersets 'sports))

(define-unit swimming
  (member-of 'collections)
  (supersets 'sports))


;; make some assertions about particular sports
(assertion 'skiing 'during-season 'winter)

(assertion 'water-skiing 'during-season 'summer)

(assertion 'skiing 'outdoor T)

(assertion 'skiing 'indoor nil)

(assertion 'water-skiing 'outdoor T)

(assertion 'water-skiing 'indoor nil)



;; define some culture

(define-unit books
  (member-of 'collections)
  (supersets 'culture))

;;   define  MUSIC  and some  subsets
(define-unit music
  (member-of 'collections)
  (supersets 'culture))

(define-unit jazz
  (member-of 'collections)
  (supersets 'music))

(define-unit classical
  (member-of 'collections)
  (supersets 'music))

(define-unit rock
  (member-of 'collections)
  (supersets 'music))

(define-unit folk-music
  (member-of 'collections)
  (supersets 'music))

(define-unit rap
  (member-of 'collections)
  (supersets 'music))

(define-unit punk-rock
  (member-of 'collections)
  (supersets 'music))


;;   define  DANCE  and some  subsets
(define-unit dance
  (member-of 'collections)
  (supersets 'culture))

(define-unit ballet
  (member-of 'collections)
  (supersets 'dance))

(define-unit modern-dance
  (member-of 'collections)
  (supersets 'dance))

(define-unit jazz-dance
  (member-of 'collections)
  (supersets 'dance))

;; define some SOCIAL ACTIVITIES

(define-unit partying
  (member-of  'collections)
  (supersets 'social-activities))

(define-unit bar-hopping
  (member-of 'collections)
  (supersets 'social-activities))

(define-unit hanging-out
  (member-of 'collections)
  (supersets 'social-activities))

(define-unit playing-charades
  (member-of 'collections)
  (supersets 'social-activities))

(define-unit eating-out
  (member-of 'collections)
  (supersets 'social-activities))


;; We  want  to  allow  for kinds  of kinds of activities.
;; These are of two type: collections which are subsets of activities,
;; and tests  which are specializations of tests for subsets of  activities
;; this  allows us to  define things  like "winter-sportp", which a 
;; kind of kind of sport, as well as "skiing", which is a kind of sport
 
(deffcn kind-of-activityp (type)
  (annotations (works-like prototypical-test))
  (and (unitp type) 
       (if (collectionp type) 
         (funcall (get-value 'activities 'subset-test) type) 
         (query  
          (get-value 'activities 'subset-test) 'specializations type))
       )
  )

;; a person  has a set of activities which they  do. They can be
;; collections or tests

(define-unit does-activities 
  (member-of 'many-valued-slots)
  (makes-sense-for 'humans)
  (must-be 'kind-of-activityp)
)


;; define seasonal activities and sports

(deffcn winterp has-value 
  (tests-slot 'during-season)
  (tests-for-value 'winter))


(deffcn winter-sportp test-intersection
  (intersection-of (get-value 'sports 'subset-test))
  (intersection-of 'winterp))

(deffcn summerp has-value 
  (tests-slot 'during-season)
  (tests-for-value 'summer))

(deffcn summer-sportp test-intersection
  (intersection-of (get-value 'sports 'subset-test))
  (intersection-of 'summerp))

(deffcn springp has-value 
  (tests-slot 'during-season)
  (tests-for-value 'spring))

(deffcn spring-sportp test-intersection
  (intersection-of (get-value 'sports 'subset-test))
  (intersection-of 'springp))


(deffcn fallp has-value 
  (tests-slot 'during-season)
  (tests-for-value 'fall))

(deffcn fall-sportp test-intersection
  (intersection-of (get-value 'sports 'subset-test))
  (intersection-of 'fallp))







  
  
  