;;; -*- LISP -*-

(in-package :huh)

(define-parser (sentence subject-verb-phrase)
    ((subject noun-phrase)
     (verb-form verb-phrase)
     (end (the-end-of-the-sentence |.|))
     (case-frame (values-of (car verb-form) case-frames)))
  `(create-object
    ,@(fill-case-frame case-frame
       (list* (car verb-form) subject (cdr verb-form)))))

(define-parser (sentence did-question)
    ((opener (is-exactly-one-of did does do))
     (subject noun-phrase)
     (verb-form verb-phrase)
     (end (the-end-of-the-sentence |?|))
     (case-frame (values-of (car verb-form) case-frames)))
  `(answer '(,@(fill-case-frame case-frame
		(list* (car verb-form) () (cdr verb-form))))
    ',(car (cadr case-frame))
    ,subject))
(define-parser (sentence who-vp)
    ((query-word (is-exactly-one-of who))
     (verb-form verb-phrase)
     (end (the-end-of-the-sentence |?|))
     (case-frame (values-of (car verb-form) case-frames)))
  `(answer '(,@(fill-case-frame case-frame
		(list* (car verb-form) () (cdr verb-form))))
    ',(car (cadr case-frame))))

(define-parser (sentence who-did-vp)
    ((query-word (is-exactly-one-of what who))
     (inverter (is-exactly-one-of did does do))
     (subject noun-phrase)
     (verb-form verb-phrase)
     (end (the-end-of-the-sentence |?|))
     (case-frame (values-of (car verb-form) case-frames)))
  `(answer '(,@(fill-case-frame case-frame
		(list* (car verb-form) subject (cdr verb-form))))
    ',(car (caddr case-frame))))

(define-parser (sentence where-did-vp)
    ((query-word (is-exactly-one-of where))
     (inverter (is-exactly-one-of did does do))
     (subject noun-phrase)
     (verb-form verb-phrase)
     (end (the-end-of-the-sentence |?|))
     (case-frame (values-of (car verb-form) case-frames)))
  `(answer '(,@(fill-case-frame case-frame
		(list* (car verb-form) subject (cdr verb-form))))
    ',(car (cadr case-frame))))

(defun fill-case-frame (case-frame particulars)
  (let ((verb          (car particulars)) ; Here for symmetry
	(event-type    (car case-frame))
	(subject       (cadr particulars))
	(subject-slots (cadr case-frame))
	(object        (caddr particulars))
	(object-slots  (caddr case-frame))
	(indirect-object       (cadddr particulars))
	(indirect-object-slots (cadddr case-frame))
	(modifiers             (cddddr particulars))
	(modifier-slots        (cddddr case-frame)))
    (declare (ignore verb))
    `((member-of ',event-type)
      ,@(and subject `((,subject-slots ,subject)))
      ,@(and object  `((,object-slots ,object)))
      ,@(and indirect-object
	 `((,indirect-object-slots ,indirect-object)))
      ,@(remove NIL (mapcar #'(lambda (prop)
				(let ((match (assoc (car prop) modifier-slots :test 'same-word-p)))
				  (and match `(,(cdr match) ,(cadr prop)))))
		     modifiers)))))


;;;; Verbs with case frames.

(define-parser (verb-phrase just-verb)
    ((verb-form (satisfies verbs)))
  `(,verb-form () ()))

(define-parser (verb-phrase verb-object)
    ((verb-form (satisfies verbs))
     (object noun-phrase))
  `(,verb-form ,object ()))

(define-parser (verb-phrase verb-indirect-object)
    ((verb-form (satisfies verbs))
     (indirect-object noun-phrase)
     (object noun-phrase))
  `(,verb-form ,object ,indirect-object))

(define-parser (verb-phrase verb-indirect-object-preps)
    ((verb-form (satisfies verbs))
     (indirect-object noun-phrase)
     (object noun-phrase)
     (modifications prepositional-phrases))
  `(,verb-form ,object ,indirect-object ,@modifications))

(define-parser (verb-phrase verb-object-preps)
    ((verb-form (satisfies verbs))
     (object noun-phrase)
     (modifications prepositional-phrases))
  `(,verb-form ,object () ,@modifications))

(define-parser (verb-phrase verb-preps)
    ((verb-form (satisfies verbs))
     (modifications prepositional-phrases))
  `(,verb-form () () ,@modifications))


;;;; Prepositional phrase

(define-parser (prepositional-phrases default)
    ((prep (satisfies prepositions))
     (object noun-phrase)
     (more prepositional-phrases))
  (cons (list prep object) more))
(define-parser (prepositional-phrases object-is-class)
    ((prep (is-exactly-one-of by for))
     (class (interpretation class-interpretation))
     (more prepositional-phrases))
  (cons (list prep `(create-object (member-of ',class))) more))
(define-parser (prepositional-phrases null-parse)
    ()
  '())

