;;;; -*- LISP -*-

(in-package :arlotje)

(define-collection body-parts (things)
  (english-description "This is the collection of body parts."))

(define-slot material single-valued-slots things symbolp
  (english-description "This the material from which a thing is made.")
  (pushes-through 'contains))

(define-structure biped (things)
  (head (should-be 'body-parts)
	(structure '(above torso))
	(genl-slots 'contains))
  (torso (should-be 'body-parts)
	 (structure '(above trunk))
	 (genl-slots 'contains))
  (trunk (should-be 'body-parts)
	 (structure '(contains right-leg))
	 (structure '(contains left-leg))
	 (genl-slots 'contains))
  (right-leg (should-be 'body-parts)
	     (structure '(right-of left-leg)))
  (left-leg (should-be 'body-parts)))

(define-individual biped-1 (biped)
  (head 'head-1)
  (torso 'torso-1)
  (trunk 'trunk-1)
  (right-leg 'leg-1)
  (left-leg 'leg-2))

(define-individual biped-2 (biped)
  (head 'head-2)
  (torso 'torso-1)
  (trunk 'trunk-1)
  (right-leg 'leg-1)
  (left-leg 'leg-2)))