;;; -*- Package: ARLOTJE -*-

;;; Representing a simple device

(define-unit devices
  (member-of 'collections)
  (generalizations 'artifacts))

(define-unit thermostats
  (member-of 'collections)
  (generalizations 'devices))

(define-unit part-of
  (works-like 'transitive-slot)
  (genl-slots 'contained-in)			;???
  (makes-sense-for 'things)
  (must-be 'things))

(define-unit parts
  (works-like 'transitive-slot)
  (genl-slots 'contains)			;???
  (makes-sense-for 'things)
  (must-be 'things)
  (inverse-slot 'part-of))

;;; A thermostat has a room, a switch, and an air-conditioner

;; Imaginary syntax
(define-structure thermostat
  (room (affects switch))
  (switch (affects air-conditioner))
  (air-conditioner (affects room))
  (when ((member too-hot (state room))
	 (put (state switch) on)))
  (when ((eq (state switch) on)
	 (put (state air-conditioner) on)))
  (when ((eq (state air-conditioner) on)
	 (put (state room) (...cooler...)))
    ))

;;; Standard syntax
(define-unit rooms
  (member-of 'collections)
  (generalizations 'things))
(define-unit switches
  (member-of 'collections)
  (generalizations 'things))
(define-unit air-conditioners
  (member-of 'collections)
  (generalizations 'things))


(define-unit affects
  (works-like 'prototypical-slot)
  (makes-sense-for 'things))

(define-unit affected-by
  (works-like 'prototypical-slot)
  (makes-sense-for 'things)
  (inverse-slot 'affects))

(define-unit room-part 
  (works-like 'prototypical-slot)
  (genl-slots 'parts)			       ;; is this right?  
  (makes-sense-for 'thermostats)
  (must-be 'rooms)
  (structure '(affects switch-part)))

(define-unit switch-part 
  (works-like 'prototypical-slot)
  (genl-slots 'parts)			       ;; is this right?  
  (makes-sense-for 'thermostats)
  (must-be 'switches)
  (structure '(affects air-conditioner-part)))

(define-unit air-conditioner-part 
  (works-like 'prototypical-slot)
  (genl-slots 'parts)			       ;; is this right?  
  (makes-sense-for 'thermostats)
  (must-be 'air-conditioners)
  (structure '(affects room-part)))

(defun instantiate (collection &optional (name (gensymbol collection)))
  (declare-unit name)
  (assertion name 'member-of collection)
  (dolist (s (get-value collection 'sensible-slots))
    (when (member 'parts (get-value s 'genl-slots))	; Definitely not right
      (put-value name s (instantiate (get-value s 'must-be)))))
  name)