;;; -*- LISP -*-

;;.@chapter An Example: Representing Families

(in-package 'families :use '(arlotje lisp))


;;;; Examples

(define-unit Mother
  (english-description "A person's mother.")
  (works-like 'prototypical-slot)
  (makes-sense-for 'humans)
  (must-be 'women))
(define-unit Father
  (english-description "A person's father.")
  (works-like 'prototypical-slot)
  (makes-sense-for 'humans)
  (must-be 'men))
(define-unit Parents
  (works-like 'prototypical-set-slot)
  (spec-slots 'mother)
  (spec-slots 'father))

(define-unit Children
  (english-description "The children of a person.")
  (works-like 'prototypical-set-slot)
  (makes-sense-for 'humans)
  (must-be 'humans)
  (inverse-slot 'parents))
(define-unit Daughters
  (works-like 'prototypical-set-slot)
  (restriction-of 'Children)
  (makes-sense-for 'humans)
  (must-be 'Women))
(define-unit Sons
  (works-like 'prototypical-set-slot)
  (restriction-of 'Children)
  (makes-sense-for 'humans)
  (must-be 'men))

(define-unit Wife
  (works-like 'prototypical-slot)
  (must-be 'women)
  (makes-sense-for 'men))
(define-unit Husband
  (works-like 'prototypical-slot)
  (makes-sense-for 'women)
  (must-be 'men)
  (inverse-slot 'wife))

(define-unit siblings
  (works-like 'prototypical-set-slot)
  (makes-sense-for 'humans)
  (must-be 'humans)
  (inverse-slot 'siblings))
(assertion 'children 'structure '(siblings children))

(define-unit brothers
  (works-like 'prototypical-set-slot)
  (restriction-of 'siblings)
  (makes-sense-for 'humans)
  (must-be 'men))
(define-unit sisters
  (works-like 'prototypical-set-slot)
  (restriction-of 'siblings)
  (makes-sense-for 'humans)
  (must-be 'women))
(assertion 'children 'structure '(mother wife))
(assertion 'children 'structure '(father husband))


;;;; An example

(define-unit anneke
  (member-of 'women))
(define-unit john
  (member-of 'men)
  (wife 'anneke))


(define-unit joep
  (member-of 'men)
  (father 'john)
  (mother 'anneke))


(define-unit tineke
  (member-of 'women)
  (father 'john)
  (mother 'anneke))
(define-unit truus
  (member-of 'women)
  (father 'john)
  (mother 'anneke))
(define-unit Han
  (member-of 'men)
  (father 'john)
  (mother 'anneke))


;;;; Second pass

(define-unit marriages
  (member-of 'collections)
  (sensible-slots
   (make-unit 'partners
     (works-like 'prototypical-set-slot)
     (must-be 'humans)
     (inverse-slot
      (make-unit 'in-marriages
	(works-like 'prototypical-set-slot)
	(must-be 'marriages))))))

(define-unit step-children
  (works-like 'prototypical-set-slot)
  (spec-slots 'children)
  (structure '(partners children)))
(define-unit step-parents
  (works-like 'prototypical-set-slot)
  (inverse-slot 'step-children))

(define-unit semi-siblings
  (works-like 'prototypical-set-slot)
  (structure '(father children))
  (structure '(mother children)))

(define-unit step-siblings
  (structure '(father children)))


