;;; -*- LISP -*-

;;.@chapter Representing Fuzzy Numbers

(in-package 'rects :use '(arlotje))


;;;;

(define-unit rectangles
  (member-of 'collections))

(define-unit left
  (member-of 'single-valued-slots)
  (makes-sense-for 'rectangles)
  (must-be 'numberp)
  (constraint-methods '(- right width)))
(define-unit top
  (member-of 'single-valued-slots)
  (makes-sense-for 'rectangles)
  (must-be 'numberp)
  (constraint-methods '(- bottom height)))
(define-unit right
  (member-of 'single-valued-slots)
  (makes-sense-for 'rectangles)
  (must-be 'numberp)
  (constraint-methods '(+ left width)))
(define-unit bottom
  (member-of 'single-valued-slots)
  (makes-sense-for 'rectangles)
  (must-be 'numberp)
  (constraint-methods '(+ top height)))
(define-unit width
  (member-of 'single-valued-slots)
  (makes-sense-for 'rectangles)
  (must-be 'numberp)
  (constraint-methods '(- right left)))
(define-unit height
  (member-of 'single-valued-slots)
  (makes-sense-for 'rectangles)
  (must-be 'numberp)
  (constraint-methods '(- bottom top)))

