/*
 Copyright (C) Johan Ceuppens 2009,2010,2011,2012 
*/
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "stack.h"

int make_stack(Stack **st)
{
	*st = (Stack *)malloc(sizeof(Stack));
	(*st)->length = 0;
	(*st)->stack = NULL;

}		

int stack_push(Stack **st, char **e, char **name)
{
	int i = 0;
	if (*st == NULL)
		return -1;	

	StackElt *se = (StackElt *)malloc(sizeof(StackElt));

	if (se == NULL) return -1;

	se->elt = strdup(*e);
	se->name = strdup(*name);
	se->next = (*st)->stack;
	(*st)->stack = se;
	(*st)->length ++;

	printf("STACK=%s\n",se->elt);
	
	return 1;
}

int stack_pop_andreturn(Stack **st, char **ret, char **retname) 
{
	int i = 0;
	if (*st == NULL)
		return -1;	

	StackElt *tmp = (*st)->stack;
	if (tmp != NULL) {
		 *ret = (*st)->stack->elt;
		 *retname = (*st)->stack->name;
	 } else { 
		 *ret = NULL;
		return -1;
		}
	//*ret = malloc(sizeof(*tmp));
	//memcpy(*ret, tmp, sizeof(tmp));
	(*st)->stack = tmp->next;	
	(*st)->length --;
	return 1;
}

int stack_pop(Stack **st) 
{
	int i = 0;
	if (*st == NULL)
		return -1;	

	StackElt *tmp = (*st)->stack;
	(*st)->stack = tmp->next;	

	free(tmp);
	(*st)->length --;

	return 1;
}

void stack_print(Stack **st)
{
	int i = 0;
	StackElt *tmp = (*st)->stack;
	for (i = 0; i < (*st)->length - 1; i++) {
		fprintf(stdout, "Stack print : %s\n", (char *)(*st)->stack);//FIXME char * -> void * 
		tmp = tmp->next;	

	}
	
}

#if 0 
int main()
{

	Stack *s;
	int i = 12;	
	make_stack(&s);
	char *e = &i;
	stack_push(&s, e); 

	char *e2 = &i;
	stack_push(&s, e2); 
	
	char *e3 = &i;
	stack_push(&s, e2); 
	
	char *e4 = &i;
	stack_push(&s, e2); 

	stack_print(&s);
	
	stack_pop(&s);
	stack_pop(&s);
	
	stack_print(&s);

	return 0;
}
#endif
