;;; $Id: util.scm,v 1.5 1994/01/26 11:40:33 queinnec Exp $
;;; Copyright (c) 1990-93 by Christian Queinnec. All rights reserved.
;;;oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;;;                        LiSP2TeX
;;;   Christian Queinnec             or to:  Christian Queinnec
;;;   <queinnec@polytechnique.fr>            <Christian.Queinnec@inria.fr>
;;;   Laboratoire d'Informatique de l'X      INRIA -- Rocquencourt
;;;   Ecole Polytechnique                    Domaine de Voluceau, BP 105
;;;   91128 Palaiseau                        78153 Le Chesnay Cedex
;;;   France                                 France
;;;oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo

;;; This program is distributed in the hope that it will be useful.
;;; Use and copying of this software and preparation of derivative works
;;; based upon this software are permitted, so long as the following
;;; conditions are met:
;;;      o credit to the authors is acknowledged following current
;;;        academic behaviour
;;;      o no fees or compensation are charged for use, copies, or
;;;        access to this software
;;;      o this copyright notice is included intact.
;;; This software is made available AS IS, and no warranty is made about
;;; the software or its performance.

;;;oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;;; These functions do not serve to LiSPTeX. They are there to be
;;; included in the documentation with the FromFile directive.

(define (extend* f x* y*)
  (if (pair? x*)
      (if (pair? y*)
          (extend (extend* f (cdr x*) (cdr y*)) (car x*) (car y*))
          (wrong "Not enough images") )
      (if (null? y*) 
          f
          (wrong "Too much images") ) ) ) 

(define (extend f x y)
  (lambda (u) 
    (if (equal? u x) y (f u)) ) )

;;; This is the expression used to present the indexing modes.

(define (foo x y z) (list x ((lambda (y z) (list y z)) (list x y) z)))

;;; The aim of this function is to provoke an error. You can hook it
;;; on the precise error machinery of your preferred Scheme. The first
;;; programmation just said (car 'not-a-pair-in-wrong) but Bigloo is 
;;; smart enough to emit a warning so I hide a little that I want to
;;; provoke an error.

(define (wrong . args)
  (let ((g (lambda (f)
             (lambda (n) 
               (cons args (f n 0)) ) )))
    ((g /) 42) ) )

;;; end of util.scm
