;;; $Id: util.scm,v 1.7 1992/04/17 21:25:54 queinnec Exp $
;;; These functions do not belong to IEEE Scheme Standard.
;;; You might need them.

(define (reverse! l)
  (define (nreverse l r)
    (if (pair? l)
        (let ((cdrl (cdr l)))
          (set-cdr! l r)
          (nreverse cdrl l) )
        r ) )
  (nreverse l '()) )

(define (mapcan fn l)
  (if (pair? l)
      (append (fn (car l))
              (mapcan fn (cdr l)) )
      '() ) )

(define (atom? e)
  (not (pair? e)) )

(define call/cc call-with-current-continuation)

(define (string-uppercase string)
  (let* ((n (string-length string))
         (s  (make-string n)) )
    (do ((i 0 (+ i 1)))
        ((= i n) s)
      (string-set! s i (char-upcase (string-ref string i))) ) ) )

(define (string-lowercase string)
  (let* ((n (string-length string))
         (s  (make-string n)) )
    (do ((i 0 (+ i 1)))
        ((= i n) s)
      (string-set! s i (char-downcase (string-ref string i))) ) ) )
