;;; $Id: read-objects.scm,v 1.10 1992/04/03 21:45:10 queinnec beta $
;;; This file defines how symbols and strings are created by the reader.
;;; An extensible string is used to incrementally build symbols or strings.
;;; It is at the end finalized into the appropriate data structure.

;;; By default (to be compatible with Scheme->C) turn symbols to uppercase.
(define *respect-input* #f)
(define *uppercase-input* #t)
(define *lowercase-input* #f)

;;; add a character to a symbol under construction.
;;; The boolean `respect' if true imposes that the character will not be
;;; turned to upper or lower case.
(define (increment-symbol char sm respect)
  (increment-string 
   (cond (respect char)
         (*respect-input* char)
         (*uppercase-input* (char-upcase char))
         (*lowercase-input* (char-downcase char))
         (else char) )
   sm ) )

;;; add a character to an extensible string
(define (increment-string char sm)
  (let ((string (extensible-string-characters sm))
        (index (extensible-string-index sm)) )
    (string-set! string index char)
    (set-extensible-string-index! sm (+ 1 index))
    (if (< (+ 1 index) (string-length string))
        sm
        (let* ((newindex (+ 1 index))
               (newstring (make-string (* 2 newindex))) )
          (set-extensible-string-characters! sm newstring)
          (do ((i 0 (+ 1 i)))
              ((= i newindex) sm)
            (string-set! newstring i (string-ref string i)) ) ) ) ) )

;;; takes an extensible string and returns a symbol
(define (finalize-symbol sm)
  (string->symbol 
   (substring (extensible-string-characters sm) 
	      0
	      (extensible-string-index sm) ) ) )

;;; takes an extensible string and returns a string
(define (finalize-string sm)
  (substring (extensible-string-characters sm)
             0 
             (extensible-string-index sm) ) )


;;; An extensible string is extended as needed.
(define (make-extensible-string initial-size)
  (vector 'extensible-string (make-string initial-size) 0) )
(define (extensible-string-characters sm)
  (vector-ref sm 1) )
(define (set-extensible-string-characters! sm newstring)
  (vector-set! sm 1 newstring) )
(define (extensible-string-index sm)
  (vector-ref sm 2) )
(define (set-extensible-string-index! sm index)
  (vector-set! sm 2 index) )

