;;; -*-Scheme-*-
;;;
;;; $Id: wrapper.scm,v 1.1 1993/02/21 20:03:26 cph Exp $
;;;
;;; Copyright (c) 1993 Massachusetts Institute of Technology
;;;
;;; This material was developed by the Scheme project at the
;;; Massachusetts Institute of Technology, Department of Electrical
;;; Engineering and Computer Science.  Permission to copy this
;;; software, to redistribute it, and to use it for any purpose is
;;; granted, subject to the following restrictions and understandings.
;;;
;;; 1. Any copy made of this software must include this copyright
;;; notice in full.
;;;
;;; 2. Users of this software agree to make their best efforts (a) to
;;; return to the MIT Scheme project any improvements or extensions
;;; that they make, so that these may be included in future releases;
;;; and (b) to inform MIT of noteworthy uses of this software.
;;;
;;; 3. All materials developed as a consequence of the use of this
;;; software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4. MIT has made no warrantee or representation that the operation
;;; of this software will be error-free, and MIT is under no
;;; obligation to provide any services, by way of maintenance, update,
;;; or otherwise.
;;;
;;; 5. In conjunction with products arising from the use of this
;;; material, there shall be no use of the name of the Massachusetts
;;; Institute of Technology nor of any adaptation thereof in any
;;; advertising, promotional, or sales literature without prior
;;; written consent from MIT in each case.

;;;; Class Wrappers for Scheme Object System

;;; From "Efficient Method Dispatch in PCL", Gregor Kiczales and Luis
;;; Rodriguez, Proceedings of the 1990 ACM Conference on Lisp and
;;; Functional Programming.  Parts of this code are based on the
;;; September 16, 1992 PCL implementation.

(declare (usual-integrations))

(define (make-wrapper class)
  (let ((length wrapper-length))
    (let ((wrapper (make-vector (+ length 1))))
      (do ((i 0 (+ i 1)))
	  ((= i length))
	(vector-set! wrapper i (get-wrapper-cache-number)))
      (vector-set! wrapper length class)
      wrapper)))

(define-integrable wrapper-length 8)

(define-integrable (wrapper-ref wrapper index)
  (vector-ref wrapper index))

(define-integrable (wrapper-set! wrapper index cache-number)
  (vector-set! wrapper index cache-number))

(define-integrable (wrapper-class wrapper)
  (vector-ref wrapper wrapper-length))

(define (next-wrapper-index index)
  (and (fix:< (fix:+ index 1) wrapper-length)
       (fix:+ index 1)))

(define-integrable (wrapper-invalid? wrapper)
  (or (not wrapper)
      (fix:= (wrapper-ref wrapper 0) 0)))

(define-integrable wrapper-cache-number-adds-ok
  ;; This constant controls the number of non-zero bits wrapper cache
  ;; numbers will have.
  ;;
  ;; The value of this constant is the number of wrapper cache numbers
  ;; which can be added and still be certain the result will be a
  ;; fixnum.  This is used by all the code that computes primary cache
  ;; locations from multiple wrappers.
  ;;
  ;; The value of this constant is used to derive the next two which
  ;; are the forms of this constant which it is more convenient for
  ;; the runtime code to use.
  4)

(define wrapper-cache-number-supremum
  (quotient (let loop ((n 2))
	      (if (fix:fixnum? n)
		  (loop (* n 2))
		  n))
	    wrapper-cache-number-adds-ok))

(define wrapper-cache-number-mask
  (- wrapper-cache-number-supremum 1))

(define get-wrapper-cache-number
  (let ((state (make-random-state)))
    (lambda ()
      (let ((n (random wrapper-cache-number-supremum state)))
	(if (fix:= n 0)
	    (get-wrapper-cache-number)
	    n)))))