;;; -*-Scheme-*-
;;;
;;; $Id: cache.sch,v 1.1 1993/02/21 20:12:06 cph Exp $
;;;
;;; Copyright (c) 1993 Massachusetts Institute of Technology
;;;
;;; This material was developed by the Scheme project at the
;;; Massachusetts Institute of Technology, Department of Electrical
;;; Engineering and Computer Science.  Permission to copy this
;;; software, to redistribute it, and to use it for any purpose is
;;; granted, subject to the following restrictions and understandings.
;;;
;;; 1. Any copy made of this software must include this copyright
;;; notice in full.
;;;
;;; 2. Users of this software agree to make their best efforts (a) to
;;; return to the MIT Scheme project any improvements or extensions
;;; that they make, so that these may be included in future releases;
;;; and (b) to inform MIT of noteworthy uses of this software.
;;;
;;; 3. All materials developed as a consequence of the use of this
;;; software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4. MIT has made no warrantee or representation that the operation
;;; of this software will be error-free, and MIT is under no
;;; obligation to provide any services, by way of maintenance, update,
;;; or otherwise.
;;;
;;; 5. In conjunction with products arising from the use of this
;;; material, there shall be no use of the name of the Massachusetts
;;; Institute of Technology nor of any adaptation thereof in any
;;; advertising, promotional, or sales literature without prior
;;; written consent from MIT in each case.

;;;; Method Caches for Scheme Object System

(define-constant wrapper-length 8)

(define-in-line (wrapper? object)
  (and (vector? object)
       (= (vector-length object) (+ wrapper-length 2))
       (eq? (vector-ref object (+ wrapper-length 1)) wrapper-tag)))

(define-in-line (wrapper-ref wrapper index)
  (vector-ref wrapper index))

(define-in-line (wrapper-class wrapper)
  (vector-ref wrapper wrapper-length))

(define-external wrapper-tag soscache)
(define-external (make-wrapper class) soscache)
(define-external (wrapper-ref wrapper index) soscache)
(define-external (wrapper-class wrapper) soscache)
(define-external (new-cache) soscache)
(define-external (probe-cache cache wrappers) soscache)
(define-external (probe-cache-1 cache w1) soscache)
(define-external (probe-cache-2 cache w1 w2) soscache)
(define-external (probe-cache-3 cache w1 w2 w3) soscache)
(define-external (probe-cache-4 cache w1 w2 w3 w4) soscache)
(define-external (fill-cache cache wrappers value) soscache)