; macros.scm is -*- Scheme -*-
;
; Bryan's Object System
;
; (C) 1994 Bryan O'Sullivan <bosullvn@maths.tcd.ie>

; R4RS hygienic macro funnage.

(define-syntax define-generic
  (syntax-rules ()
    ((define-generic generic-name)
     (define generic-name (make-generic)))))

(define-syntax quoted-list
  (syntax-rules ()
    ((quoted-list stuff ...)
     (quote (stuff ...)))))

(define-syntax define-class
  (syntax-rules ()
    ((define-class class-name (superclasses ...) (members ...))
     (define class-name
       (i-make-class (list superclasses ...) (quote (members ...)))))))

(define-syntax make-class
  (syntax-rules ()
    ((make-class (superclasses ...) (members ...))
     (i-make-class (list superclasses ...) (quote (members ...))))))

(define-syntax define-object
  (syntax-rules ()
    ((define-object object-name class-name arguments ...)
     (define object-name (make-object class-name arguments ...)))))
